/*
 * 88w8688.c  --  ALSA Soc 88w8688 codec support
 *
 * Copyright:	Sauris GmbH
 * Author:	Sergey Markov <sauris_support@scanti.ru>
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 */

#include <linux/init.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/device.h>
#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/ac97_codec.h>
#include <sound/initval.h>
#include <sound/soc.h>

static struct snd_soc_dai_driver bt_88w8688_dai = {
	.name = "bt-88w8688",
	.playback = {
		.stream_name = "Playback",
		.channels_min = 1,
		.channels_max = 2,
		.rates = SNDRV_PCM_RATE_8000,
		.formats = SNDRV_PCM_FMTBIT_S16_LE, },
	.capture = {
		.stream_name = "Capture",
		.channels_min = 1,
		.channels_max = 2,
		.rates = SNDRV_PCM_RATE_8000,
		.formats = SNDRV_PCM_FMTBIT_S16_LE, },
};

static struct snd_soc_codec_driver soc_codec_dev_bt_88w8688;

static int bt_88w8688_probe(struct platform_device *pdev)
{

	int	rc;

	rc = snd_soc_register_codec(&pdev->dev,
			&soc_codec_dev_bt_88w8688, &bt_88w8688_dai, 1);
	if (rc) 
		printk(KERN_ERR "BT-88W8688: Can't register codec\n");

	return rc;

}

static int __devexit bt_88w8688_remove(struct platform_device *pdev)
{
	snd_soc_unregister_codec(&pdev->dev);
	return 0;
}

static struct platform_driver bt_88w8688_codec_driver = {
	.driver = {
			.name = "bt-88w8688-codec",
			.owner = THIS_MODULE,
	},

	.probe = bt_88w8688_probe,
	.remove = __devexit_p(bt_88w8688_remove),
};

static int __init bt_88w8688_init(void)
{
	return platform_driver_register(&bt_88w8688_codec_driver);
}
module_init(bt_88w8688_init);

static void __exit bt_88w8688_exit(void)
{
	platform_driver_unregister(&bt_88w8688_codec_driver);
}
module_exit(bt_88w8688_exit);

MODULE_DESCRIPTION("ASoC Marvell 88w8688 PCM interface driver");
MODULE_AUTHOR("Sauris GmbH");
MODULE_LICENSE("GPL");
