#ifndef _TCA8418_KEYS_H
#define _TCA8418_KEYS_H

#include <linux/types.h>

struct tca8418_key_codes {
  int scancode;
  int keycode;
};


struct tca8418_keys_platform_data {
	struct tca8418_key_codes * recode;
	unsigned int rep:1;	/* enable input subsystem auto repeat */
	int only_recoded;	/* if 1, events not in "recode" array are dropped */
};

#define TCA8418_REG_RSVD1		0x00
#define TCA8418_REG_CFG  		0x01
#define TCA8418_REG_INT_STAT  		0x02
#define TCA8418_REG_KEY_LCK_EC  	0x03
#define TCA8418_REG_KEY_EVENT_A		0x04
#define TCA8418_REG_KEY_EVENT_B		0x05
#define TCA8418_REG_KEY_EVENT_C		0x06
#define TCA8418_REG_KEY_EVENT_D		0x07
#define TCA8418_REG_KEY_EVENT_E		0x08
#define TCA8418_REG_KEY_EVENT_F		0x09
#define TCA8418_REG_KEY_EVENT_G		0x0A
#define TCA8418_REG_KEY_EVENT_H		0x0B
#define TCA8418_REG_KEY_EVENT_I		0x0C
#define TCA8418_REG_KEY_EVENT_J		0x0D
#define TCA8418_REG_LCK_TIMER		0x0E
#define TCA8418_REG_UNLOCK1		0x0F
#define TCA8418_REG_UNLOCK2		0x10
#define TCA8418_REG_GPIO_INT_STAT1	0x11
#define TCA8418_REG_GPIO_INT_STAT2	0x12
#define TCA8418_REG_GPIO_INT_STAT3	0x13
#define TCA8418_REG_GPIO_DAT_STAT1	0x14
#define TCA8418_REG_GPIO_DAT_STAT2	0x15
#define TCA8418_REG_GPIO_DAT_STAT3	0x16
#define TCA8418_REG_GPIO_DAT_OUT1	0x17
#define TCA8418_REG_GPIO_DAT_OUT2	0x18
#define TCA8418_REG_GPIO_DAT_OUT3	0x19
#define TCA8418_REG_GPIO_INT_EN1	0x1A
#define TCA8418_REG_GPIO_INT_EN2	0x1B
#define TCA8418_REG_GPIO_INT_EN3	0x1C
#define TCA8418_REG_KP_GPIO1		0x1D
#define TCA8418_REG_KP_GPIO2		0x1E
#define TCA8418_REG_KP_GPIO3		0x1F
#define TCA8418_REG_GPI_EM1		0x20
#define TCA8418_REG_GPI_EM2		0x21
#define TCA8418_REG_GPI_EM3		0x22
#define TCA8418_REG_GPIO_DIR1		0x23
#define TCA8418_REG_GPIO_DIR2		0x24
#define TCA8418_REG_GPIO_DIR3		0x25
#define TCA8418_REG_GPIO_INT_LVL1	0x26
#define TCA8418_REG_GPIO_INT_LVL2	0x27
#define TCA8418_REG_GPIO_INT_LVL3	0x28
#define TCA8418_REG_DEBOUNCE_DIS1	0x29
#define TCA8418_REG_DEBOUNCE_DIS2	0x2A
#define TCA8418_REG_DEBOUNCE_DIS3	0x2B
#define TCA8418_REG_GPIO_PULL1		0x2C
#define TCA8418_REG_GPIO_PULL2		0x2D
#define TCA8418_REG_GPIO_PULL3		0x2E
#define TCA8418_REG_RSVD2		0x2F

#endif
