/*
 * linux/drivers/char/ti81xx_hdmi/regoffsets.h
 *
 * Copyright (C) 2010 Texas Instruments
 *
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*********************************PHY Registers********************************/
/* PHY registers for TI816x  */
#ifdef CONFIG_ARCH_TI816X
#define PHY_TMDS_CNTL1_OFFSET			(0x00000000)
#define PHY_TMDS_CNTL2_OFFSET			(0x00000004)
#define PHY_TMDS_CNTL3_OFFSET			(0x00000008)
#define PHY_BIST_CNTL_OFFSET			(0x0000000C)
#define PHY_BIST_PATTERN_OFFSET			(0x00000010)
#define PHY_BIST_INST0_OFFSET			(0x00000014)
#define PHY_BIST_INST1_OFFSET			(0x00000018)
#define PHY_BIST_CONF0_OFFSET			(0x0000001C)
#define PHY_TMDS_CNTL9_OFFSET			(0x00000020)
#define PHY_TMDS_CNTL10_OFFSET			(0x00000024)
#define PHY_TEST_MUX_CTRL_OFFSET		(0x00000028)

#define HDMI_PHY_TMDS_CNTL3_PDB_MASK			(0x00000001u)
#define HDMI_PHY_TMDS_CNTL3_DPCOLOR_CTL_MASK		(0x00000006u)
#define HDMI_PHY_TMDS_CNTL3_CLKMULT_CTL_MASK		(0x00000018u)
#define HDMI_PHY_TMDS_CNTL3_BIST_SEL_MASK		(0x00000040u)
#define HDMI_PHY_TMDS_CNTL3_DPCOLOR_CTL_SHIFT		(0x00000001u)
#define HDMI_PHY_TMDS_CNTL3_DPCOLOR_CTL_NO		(0x00000000u)
#define HDMI_PHY_TMDS_CNTL3_DPCOLOR_CTL_10BITCHANNEL	(0x00000001u)
#define HDMI_PHY_TMDS_CNTL3_DPCOLOR_CTL_12BITCHANNEL	(0x00000002u)
#define HDMI_PHY_TMDS_CNTL3_CLKMULT_CTL_0_5X		(0x00000000u)
#define HDMI_PHY_TMDS_CNTL3_CLKMULT_CTL_1_0X		(0x00000001u)
#define HDMI_PHY_TMDS_CNTL3_CLKMULT_CTL_2_0X		(0x00000002u)
#define HDMI_PHY_TMDS_CNTL3_CLKMULT_CTL_4_0X		(0x00000003u)
#define HDMI_PHY_TMDS_CNTL3_CLKMULT_CTL_SHIFT		(0x00000003u)
#define HDMI_PHY_BIST_CNTL_BIST_EN_MASK			(0x00000001u)
#define HDMI_PHY_BIST_CNTL_BIST_ON_MASK			(0x00000002u)
#define HDMI_PHY_BIST_CNTL_ENC_BYP_MASK 		(0x00000004u)
#define HDMI_PHY_TMDS_CNTL2_TERM_EN_MASK		(0x00000010u)
#define HDMI_PHY_TMDS_CNTL2_OE_MASK 		(0x00000020u)

#else

/* PHY registers for TI814x */
#define HDMI_PHY_TX_CTRL_OFF				(0x00000000u)
#define HDMI_PHY_DIGITAL_CTRL_OFF			(0x00000004u)
#define HDMI_PHY_PWR_CTRL_OFF				(0x00000008u)
#define HDMI_PHY_PAD_CFG_CTRL_OFF			(0x0000000Cu)
#define HDMI_PHY_TRIM_TEST_CTRL_OFF			(0x00000010u)
#define HDMI_PHY_ANG_INT_CTRL_OFF			(0x00000014u)
#define HDMI_PHY_DATA_INT_CTRL_OFF			(0x00000018u)
#define HDMI_PHY_BIST_OFF				(0x0000001Cu)

#define HDMI_PHY_FRQ_OUT_MASK				(0xC0000000u)
#define HDMI_PHY_FRQ_OUT_SHIFT				(30)
#define HDMI_PHY_SRC_TERM_MASK				(0x30000000u)
#define HDMI_PHY_SRC_TERM_SHIFT				(28)
#define HDMI_PHY_EMPEN_D0_MASK				(0x08000000u)
#define HDMI_PHY_EMPEN_D0_SHIFT				(27)
#define HDMI_PHY_EMPEN_D1_MASK				(0x04000000u)
#define HDMI_PHY_EMPEN_D1_SHIFT				(26)
#define HDMI_PHY_EMPEN_D2_MASK				(0x02000000u)
#define HDMI_PHY_EMPEN_D2_SHIFT				(25)
#define HDMI_PHY_EMPEN_CLK_MASK				(0x01000000u)
#define HDMI_PHY_EMPEN_CLK_SHIFT			(24)
#define HDMI_PHY_PROGEM_D0_MASK				(0x00D00000u)
#define HDMI_PHY_PROGEM_D0_SHIFT			(21)
#define HDMI_PHY_PROGEM_D1_MASK				(0x001C0000u)
#define HDMI_PHY_PROGEM_D1_SHIFT			(18)
#define HDMI_PHY_PROGEM_D2_MASK				(0x00038000u)
#define HDMI_PHY_PROGEM_D2_SHIFT			(15)
#define HDMI_PHY_PROGEM_CLK_MASK			(0x00007000u)
#define HDMI_PHY_PROGEM_CLK_SHIFT			(12)
#define HDMI_PHY_SLOWEDGE_D0_MASK			(0x00000C00u)
#define HDMI_PHY_SLOWEDGE_D0_SHIFT			(10)
#define HDMI_PHY_SLOWEDGE_D1_MASK			(0x00000300u)
#define HDMI_PHY_SLOWEDGE_D1_SHIFT			(8)
#define HDMI_PHY_SLOWEDGE_D2_MASK			(0x000000C0u)
#define HDMI_PHY_SLOWEDGE_D2_SHIFT			(6)
#define HDMI_PHY_SLOWEDGE_CLK_MASK			(0x00000030u)
#define HDMI_PHY_SLOWEDGE_CLK_SHIFT			(4)
#define HDMI_PHY_TXLOWCM_MASK				(0x00000008u)
#define HDMI_PHY_TXLOWCM_SHIFT				(3)
#define HDMI_PHY_TXLOWI_MASK				(0x00000006u)
#define HDMI_PHY_TXLOWI_SHIFT				(1)

#define HDMI_PHY_USE_TMDSCLKEN_MASK			(0x80000000u)
#define HDMI_PHY_USE_TMDSCLKEN_SHIFT			(31)
#define HDMI_PHY_TMDSCLKEN_MASK				(0x40000000u)
#define HDMI_PHY_TMDSCLKEN_SHIFT			(30)
#define HDMI_PHY_USE_TXVALID_MASK			(0x20000000u)
#define HDMI_PHY_USE_TXVALID_SHIFT			(29)
#define HDMI_PHY_TXVALID_MASK				(0x10000000u)
#define HDMI_PHY_TXVALID_SHIFT				(28)

#define HDMI_PHY_FORCELDOON_MASK			(0x80000000u)
#define HDMI_PHY_FORCELDOON_SHIFT			(31)
#define HDMI_PHY_LDO_POWERUP_COUNTER_MASK		(0x7F000000u)
#define HDMI_PHY_LDO_POWERUP_COUNTER_SHIFT		(24)
#define HDMI_PHY_BGON_COUNTER_MASK			(0x00F80000u)
#define HDMI_PHY_BGON_COUNTER_SHIFT			(19)
#define HDMI_PHY_RESETDONEPIXELCLK_MASK			(0x00020000u)
#define HDMI_PHY_RESETDONEPIXELCLK_SHIFT		(17)
#define HDMI_PHY_RESETDONEPWRCLK_MASK			(0x00010000u)
#define HDMI_PHY_RESETDONEPWRCLK_SHIFT			(16)
#define HDMI_PHY_RESETDONESCPCLK_MASK			(0x00008000u)
#define HDMI_PHY_RESETDONESCPCLK_SHIFT			(15)
#define HDMI_PHY_RESETDONEREFCLK_MASK			(0x00004000u)
#define HDMI_PHY_RESETDONEREFCLK_SHIFT			(14)
#define HDMI_PHY_TBIAS_COUNTER_MASK			(0x00003F80u)
#define HDMI_PHY_TBIAS_COUNTER_SHIFT			(7)
#define HDMI_PHY_TEST_EN_LDO_FORCE_MASK			(0x00000040u)
#define HDMI_PHY_TEST_EN_LDO_FORCE_SHIFT		(6)
#define HDMI_PHY_TEST_EN_BG_FORCE_MASK			(0x00000020u)
#define HDMI_PHY_TEST_EN_BG_FORCE_SHIFT			(5)
#define HDMI_PHY_TEST_EN_SC_FORCE_MASK			(0x00000010u)
#define HDMI_PHY_TEST_EN_SC_FORCE_SHIFT			(4)
#define HDMI_PHY_LDOVOLTAGE_MASK			(0x0000000Fu)
#define HDMI_PHY_LDOVOLTAGE_SHIFT			(0)

#define HDMI_PHY_PADORDER_MASK				(0x80000000u)
#define HDMI_PHY_PADORDER_SHIFT				(31)
#define HDMI_PHY_FLIP_P_N_ORDER_D0_MASK			(0x40000000u)
#define HDMI_PHY_FLIP_P_N_ORDER_D0_SHIFT		(30)
#define HDMI_PHY_FLIP_P_N_ORDER_D1_MASK			(0x20000000u)
#define HDMI_PHY_FLIP_P_N_ORDER_D1_SHIFT		(29)
#define HDMI_PHY_FLIP_P_N_ORDER_D2_MASK			(0x10000000u)
#define HDMI_PHY_FLIP_P_N_ORDER_D2_SHIFT		(28)
#define HDMI_PHY_FLIP_P_N_ORDER_CLK_MASK		(0x08000000u)
#define HDMI_PHY_FLIP_P_N_ORDER_CLK_SHIFT		(27)
#define HDMI_PHY_ASSIGN_CH_MASK				(0x07C00000u)
#define HDMI_PHY_ASSIGN_CH_SHIFT			(22)
#define HDMI_PHY_DET5VSHT_CLK_MASK			(0x000C0000u)
#define HDMI_PHY_DET5VSHT_CLK_SHIFT			(18)
#define HDMI_PHY_VTHRESHPU_CNTL_MASK			(0x00030000u)
#define HDMI_PHY_VTHRESHPU_CNTL_SHIFT			(16)
#define HDMI_PHY_FORCE_RXDET_HI_MASK			(0x00008000u)
#define HDMI_PHY_FORCE_RXDET_HI_SHIFT			(15)
#define HDMI_PHY_RXDET_LINE_MASK			(0x00007F80u)
#define HDMI_PHY_RXDET_LINE_SHIFT			(7)
#define HDMI_PHY_DET5VSHT_DATA_MASK			(0x0000007Eu)
#define HDMI_PHY_DET5VSHT_DATA_SHIFT			(1)

#define HDMI_PHY_USE_BGTRIM_REG_MASK			(0x80000000u)
#define HDMI_PHY_USE_BGTRIM_REG_SHIFT			(31)
#define HDMI_PHY_BGTRIM_MASK				(0x7FFF0000u)
#define HDMI_PHY_BGTRIM_SHIFT				(16)
#define HDMI_PHY_USE_SWTRIM_REG_MASK			(0x00008000u)
#define HDMI_PHY_USE_SWTRIM_REG_SHIFT			(15)
#define HDMI_PHY_SWTRIM_MASK				(0x00007F00u)
#define HDMI_PHY_SWTRIM_SHIFT				(8)
#define HDMI_PHY_TRIMMODE_BG_MASK			(0x00000080u)
#define HDMI_PHY_TRIMMODE_BG_SHIFT			(7)
#define HDMI_PHY_TRIMMODE_SC_MASK			(0x00000040u)
#define HDMI_PHY_TRIMMODE_SC_SHIFT			(6)
#define HDMI_PHY_USE_TRIMMODE_REGS_MASK			(0x00000020u)
#define HDMI_PHY_USE_TRIMMODE_REGS_SHIFT		(5)

#define HDMI_PHY_ANALOG_DEBUG_MASK			(0xFFFF0000u)
#define HDMI_PHY_ANALOG_DEBUG_SHIFT			(16)
#define HDMI_PHY_USELDOPGD_REG_MASK			(0x00008000u)
#define HDMI_PHY_USELDOPGD_REG_SHIFT			(15)
#define HDMI_PHY_LDOPGD_MASK				(0x00004000u)
#define HDMI_PHY_LDOPGD_SHIFT				(14)
#define HDMI_PHY_BGON_MASK				(0x00002000u)
#define HDMI_PHY_BGON_SHIFT				(13)
#define HDMI_PHY_TXON_MASK				(0x00001000u)
#define HDMI_PHY_TXON_SHIFT				(12)
#define HDMI_PHY_TXONDELAYED_MASK			(0x00000800u)
#define HDMI_PHY_TXONDELAYED_SHIFT			(11)
#define HDMI_PHY_USE_CLKLANEPOS_MASK			(0x00000400u)
#define HDMI_PHY_USE_CLKLANEPOS_SHIFT			(10)
#define HDMI_PHY_CLOCK_LANE_POS_MASK			(0x00000300u)
#define HDMI_PHY_CLOCK_LANE_POS_SHIFT			(8)
#define HDMI_PHY_ANALOG_CHAR_MASK			(0x000000FFu)
#define HDMI_PHY_ANALOG_CHAR_SHIFT			(0)

#define HDMI_PHY_USE_DATA_REG_MASK			(0x80000000u)
#define HDMI_PHY_USE_DATA_REG_SHIFT			(31)
#define HDMI_PHY_D0_OVERRIDE_MASK			(0x7FE00000u)
#define HDMI_PHY_D0_OVERRIDE_SHIFT			(21)
#define HDMI_PHY_D1_OVERRIDE_MASK			(0x000FFC00u)
#define HDMI_PHY_D1_OVERRIDE_SHIFT			(10)
#define HDMI_PHY_D2_OVERRIDE_MASK			(0x000003FFu)
#define HDMI_PHY_D2_OVERRIDE_SHIFT			(0)

#define HDMI_PHY_USE_LDOBIST_CTRL_MASK			(0x80000000u)
#define HDMI_PHY_USE_LDOBIST_CTRL_SHIFT			(31)
#define HDMI_PHY_LDOBIST_CTRL_MASK			(0x40000000u)
#define HDMI_PHY_LDOBIST_CTRL_SHIFT			(30)
#define HDMI_PHY_LDO_BIST_OK1_MASK			(0x20000000u)
#define HDMI_PHY_LDO_BIST_OK1_SHIFT			(29)
#define HDMI_PHY_LDO_BIST_OK2_MASK			(0x10000000u)
#define HDMI_PHY_LDO_BIST_OK2_SHIFT			(28)
#define HDMI_PHY_USE_LB_MODE_MASK			(0x08000000u)
#define HDMI_PHY_USE_LB_MODE_SHIFT			(27)
#define HDMI_PHY_LB_MODE_MASK				(0x04000000u)
#define HDMI_PHY_LB_MODE_SHIFT				(26)
#define HDMI_PHY_LB_COMP_MASK				(0x02000000u)
#define HDMI_PHY_LB_COMP_SHIFT				(25)
#define HDMI_PHY_USE_LB_LANE_SEL_MASK			(0x01000000u)
#define HDMI_PHY_USE_LB_LANE_SEL_SHIFT			(24)
#define HDMI_PHY_LB_LANE_SEL_MASK			(0x00C00000u)
#define HDMI_PHY_LB_LANE_SEL_SHIFT			(22)
#define HDMI_PHY_PRBS_EN_MASK				(0x003C0000u)
#define HDMI_PHY_PRBS_EN_SHIFT				(18)
#endif /* CONFIG_ARCH_TI816X */
/************************************WP****************************************/
#define HDMI_WP_SYSCONFIG_OFFSET               (0x00000008)
#define HDMI_WP_IRQSTATUS_RAW_OFFSET		(0x00000024)
#define HDMI_WP_PWR_CTRL_OFFSET			(0x00000040)
#define HDMI_WP_DEBOUNCE_OFFSET			(0x00000044)
#define HDMI_WP_VIDEO_CFG_OFFSET		(0x00000050)
#define HDMI_WP_VIDEO_TIMING_H_OFFSET		(0x00000068)
#define HDMI_WP_VIDEO_TIMING_V_OFFSET		(0x0000006C)
#define HDMI_WP_CLK_OFFSET			(0x00000070)
#define HDMI_WP_AUDIO_CFG_OFFSET		(0x00000080)
#define HDMI_WP_AUDIO_CTRL_OFFSET		(0x00000088)

#define HDMI_WP_SYSCONFIG_SOFTRESET_MASK	(0x00000001u)
#define HDMI_WP_IRQSTATUS_CORE_INTR_PEND_MASK	(0x00000001u)
#define HDMI_WP_DEBOUNCE_RXDET_MASK		(0x00003F00u)
#define HDMI_WP_DEBOUNCE_RXDET_SHIFT		(0x00000008u)
#define HDMI_WP_DEBOUNCE_LINE5VSHORT_MASK	(0x0000003Fu)
#define HDMI_WP_DEBOUNCE_LINE5VSHORT_SHIFT	(0x00000000u)
#define HDMI_WP_VIDEO_CFG_ENABLE_MASK		(0x80000000u)
#define HDMI_WP_VIDEO_CFG_SLAVE_CLOCK_USED_MASK	(0x00020000u)
#define HDMI_WP_VIDEO_CFG_TMDS_CLOCK_USED_MASK	(0x00010000u)
#define HDMI_WP_VIDEO_CFG_PACKING_MODE_MASK	(0x00000700u)
#define HDMI_WP_VIDEO_CFG_PACKING_MODE_SHIFT	(0x00000008u)
#define HDMI_WP_VIDEO_CFG_VSYNC_POL_MASK	(0x00000080u)
#define HDMI_WP_VIDEO_CFG_HSYNC_POL_MASK	(0x00000040u)
#define HDMI_WP_VIDEO_CFG_CORE_VSYNC_INV_MASK	(0x00000020u)
#define HDMI_WP_VIDEO_CFG_CORE_HSYNC_INV_MASK	(0x00000010u)
#define HDMI_WP_VIDEO_CFG_PROGRESSIVE_INTERLACE_MASK	(0x00000008u)
#define HDMI_WP_VIDEO_CFG_MODE_MASK		(0x00000003u)
#define HDMI_WP_VIDEO_CFG_MODE_SHIFT		(0x00000000u)
#define HDMI_WP_VIDEO_TIMING_H_HBP_MASK		(0xFFF00000u)
#define HDMI_WP_VIDEO_TIMING_H_HBP_SHIFT	(0x00000014u)
#define HDMI_WP_VIDEO_TIMING_H_HFP_MASK		(0x000FFF00u)
#define HDMI_WP_VIDEO_TIMING_H_HFP_SHIFT	(0x00000008u)
#define HDMI_WP_VIDEO_TIMING_H_HSW_MASK		(0x000000FFu)
#define HDMI_WP_VIDEO_TIMING_H_HSW_SHIFT	(0x00000000u)
#define HDMI_WP_VIDEO_TIMING_V_VBP_MASK		(0xFFF00000u)
#define HDMI_WP_VIDEO_TIMING_V_VBP_SHIFT	(0x00000014u)
#define HDMI_WP_VIDEO_TIMING_V_VFP_MASK		(0x000FFF00u)
#define HDMI_WP_VIDEO_TIMING_V_VFP_SHIFT	(0x00000008u)
#define HDMI_WP_VIDEO_TIMING_V_VSW_MASK		(0x000000FFu)
#define HDMI_WP_VIDEO_TIMING_V_VSW_SHIFT	(0x00000000u)
#define HDMI_WP_AUDIO_CTRL_DISABLE_MASK		(0x80000000u)

#define HDMI_WP_PWR_CTRL_PHY_PWR_CMD_MASK	(0x000000C0u)
#define HDMI_WP_PWR_CTRL_PHY_PWR_CMD_SHIFT	(6u)
#define HDMI_WP_PWR_CTRL_PHY_PWR_STATUS_MASK	(0x00000030u)
#define HDMI_WP_PWR_CTRL_PHY_PWR_STATUS_SHIFT	(4u)
#define HDMI_WP_PWR_CTRL_PLL_PWR_CMD_MASK	(0x0000000Cu)
#define HDMI_WP_PWR_CTRL_PLL_PWR_CMD_SHIFT	(2u)
#define HDMI_WP_PWR_CTRL_PLL_PWR_STATUS_MASK	(0x00000003u)
#define HDMI_WP_PWR_CTRL_PLL_PWR_STATUS_SHIFT	(0x0)



/************************************WP****************************************/

/************************************CORE**************************************/

#define HDMI_CORE_SRST_OFFSET			(0x00000014)
#define HDMI_CORE_SYS_CTRL1_OFFSET		(0x00000020)
#define HDMI_CORE_SYS_STAT_OFFSET		(0x00000024)
#define HDMI_CORE_RI_STAT_OFFSET		(0x00000098)
#define HDMI_CORE_DE_DLY_OFFSET			(0x000000C8)
#define HDMI_CORE_DE_CTRL_OFFSET		(0x000000CC)
#define HDMI_CORE_DE_TOP_OFFSET			(0x000000D0)
#define HDMI_CORE_DE_CNTL_OFFSET		(0x000000D4)
#define HDMI_CORE_DE_CNTH_OFFSET		(0x000000D8)
#define HDMI_CORE_DE_LINL_OFFSET		(0x000000DC)
#define HDMI_CORE_DE_LINH_OFFSET		(0x000000E0)
#define HDMI_CORE_IADJUST_OFFSET		(0x000000F8)
#define HDMI_CORE_VID_CTRL_OFFSET		(0x00000120)
#define HDMI_CORE_VID_ACEN_OFFSET		(0x00000124)
#define HDMI_CORE_VID_MODE_OFFSET		(0x00000128)
#define HDMI_CORE_DC_HEADER_OFFSET		(0x00000138)
#define HDMI_CORE_VID_DITHER_OFFSET		(0x0000013C)
#define HDMI_CORE_INTR1_OFFSET			(0x000001C4)
#define HDMI_CORE_TMDS_CTRL_OFFSET		(0x00000208)
#define HDMI_CORE_XVYCC2RGB_CTL_OFFSET		(0x00000240)
#define HDMI_CORE_Y2R_COEFF_LOW_OFFSET		(0x00000244)
#define HDMI_CORE_DDC_ADDR_OFFSET		(0x000003B4)
#define HDMI_CORE_DDC_SEGM_OFFSET		(0x000003B8)
#define HDMI_CORE_DDC_OFFSET_OFFSET		(0x000003BC)
#define HDMI_CORE_DDC_COUNT1_OFFSET		(0x000003C0)
#define HDMI_CORE_DDC_COUNT2_OFFSET		(0x000003C4)
#define HDMI_CORE_DDC_STATUS_OFFSET		(0x000003C8)
#define HDMI_CORE_DDC_CMD_OFFSET		(0x000003CC)
#define HDMI_CORE_DDC_DATA_OFFSET		(0x000003D0)
#define HDMI_CORE_DDC_FIFOCNT_OFFSET		(0x000003D4)
#define HDMI_CORE_ACR_CTRL_OFFSET		(0x00000504)
#define HDMI_CORE_AUD_MODE_OFFSET		(0x00000550)
#define HDMI_CORE_HDMI_CTRL_OFFSET		(0x000005BC)
#define HDMI_CORE_TEST_TXCTRL_OFFSET		(0x000005F0)
#define HDMI_CORE_PB_CTRL1_OFFSET		(0x000005F8)
#define HDMI_CORE_PB_CTRL2_OFFSET		(0x000005FC)
#define HDMI_CORE_AVI_TYPE_OFFSET		(0x00000600)
#define HDMI_CORE_AVI_VERS_OFFSET		(0x00000604)
#define HDMI_CORE_AVI_LEN_OFFSET		(0x00000608)
#define HDMI_CORE_AVI_CHSUM_OFFSET		(0x0000060C)
#define HDMI_CORE_AVI_DBYTE_BASE_OFFSET		(0x00000610)
#define HDMI_CORE_CP_BYTE1_OFFSET		(0x0000087C)

#define HDMI_SRST_FIFORST_MASK			(0x00000002u)
#define HDMI_SRST_FIFORST_SHIFT			(0x00000001u)
#define HDMI_SRST_SWRST_MASK			(0x00000001u)
#define HDMI_SRST_SWRST_SHIFT			(0x00000000u)
#define HDMI_SYS_CTRL1_VSYNC_MASK		(0x00000040u)
#define HDMI_SYS_CTRL1_VSYNC_SHIFT		(0x00000006u)
#define HDMI_SYS_CTRL1_VSYNC_RESETVAL		(0x00000000u)
#define HDMI_SYS_CTRL1_VEN_MASK			(0x00000020u)
#define HDMI_SYS_CTRL1_VEN_SHIFT		(0x00000005u)
#define HDMI_SYS_CTRL1_HEN_MASK			(0x00000010u)
#define HDMI_SYS_CTRL1_HEN_SHIFT		(0x00000004u)
#define HDMI_SYS_CTRL1_BSEL_MASK		(0x00000004u)
#define HDMI_SYS_CTRL1_BSEL_SHIFT		(0x00000002u)
#define HDMI_SYS_CTRL1_EDGE_MASK		(0x00000002u)
#define HDMI_SYS_CTRL1_EDGE_SHIFT		(0x00000001u)
#define HDMI_SYS_CTRL1_PD_MASK			(0x00000001u)
#define HDMI_SYS_CTRL1_PD_SHIFT			(0x00000000u)
#define HDMI_SYS_STAT_HPD_SHIFT			(0x00000001u)
#define HDMI_SYS_STAT_HPD_MASK			(0x00000002u)
#define HDMI_RI_STAT_RI_STARTED_MASK		(0x00000001u)
#define HDMI_RI_STAT_RI_STARTED_SHIFT		(0x00000000u)
#define HDMI_DE_DLY_DE_DLY_MASK			(0x000000FFu)
#define HDMI_DE_DLY_DE_DLY_SHIFT		(0x00000000u)
#define HDMI_DE_CTRL_DE_GEN_MASK		(0x00000040u)
#define HDMI_DE_CTRL_DE_GEN_SHIFT		(0x00000006u)
#define HDMI_DE_CTRL_VS_POL_MASK		(0x00000020u)
#define HDMI_DE_CTRL_VS_POL_SHIFT		(0x00000005u)
#define HDMI_DE_CTRL_HS_POL_MASK		(0x00000010u)
#define HDMI_DE_CTRL_HS_POL_SHIFT		(0x00000004u)
#define HDMI_DE_CTRL_DE_DLY_MASK		(0x0000000Fu)
#define HDMI_DE_CTRL_DE_DLY_SHIFT		(0x00000000u)
#define HDMI_DE_TOP_DE_TOP_MASK			(0x0000007Fu)
#define HDMI_DE_TOP_DE_TOP_SHIFT		(0x00000000u)
#define HDMI_DE_TOP_DE_TOP_RESETVAL		(0x00000000u)
#define HDMI_DE_CNTL_DE_CNT_MASK		(0x000000FFu)
#define HDMI_DE_CNTL_DE_CNT_SHIFT		(0x00000000u)
#define HDMI_DE_CNTH_DE_CNT_MASK		(0x0000000Fu)
#define HDMI_DE_CNTH_DE_CNT_SHIFT		(0x00000000u)
#define HDMI_DE_LINL_DE_LIN_MASK		(0x000000FFu)
#define HDMI_DE_LINL_DE_LIN_SHIFT		(0x00000000u)
#define HDMI_DE_LINH_DE_LIN_MASK		(0x00000007u)
#define HDMI_DE_LINH_DE_LIN_SHIFT		(0x00000000u)
#define HDMI_HRES_L_H_RES_MASK			(0x000000FFu)
#define HDMI_HRES_L_H_RES_SHIFT			(0x00000000u)
#define HDMI_HRES_H_H_RES_MASK			(0x0000001Fu)
#define HDMI_HRES_H_H_RES_SHIFT			(0x00000000u)
#define HDMI_VRES_L_V_RES_MASK			(0x000000FFu)
#define HDMI_VRES_L_V_RES_SHIFT			(0x00000000u)
#define HDMI_VRES_H_V_RES_MASK			(0x00000007u)
#define HDMI_VRES_H_V_RES_SHIFT			(0x00000000u)
#define HDMI_IADJUST_DE_ADJ_MASK		(0x00000004u)
#define HDMI_IADJUST_DE_ADJ_SHIFT		(0x00000002u)
#define HDMI_IADJUST_F2VADJ_MASK		(0x00000002u)
#define HDMI_IADJUST_F2VADJ_SHIFT		(0x00000001u)
#define HDMI_IADJUST_F2VOFST_MASK		(0x00000001u)
#define HDMI_IADJUST_F2VOFST_SHIFT		(0x00000000u)
#define HDMI_IADJUST_RESETVAL			(0x00000006u)
#define HDMI_VID_CTRL_IFPOL_MASK		(0x00000080u)
#define HDMI_VID_CTRL_IFPOL_SHIFT		(0x00000007u)
#define HDMI_VID_CTRL_EXTN_MASK			(0x00000020u)
#define HDMI_VID_CTRL_EXTN_SHIFT		(0x00000005u)
#define HDMI_VID_CTRL_CSCSEL_MASK		(0x00000010u)
#define HDMI_VID_CTRL_CSCSEL_SHIFT		(0x00000004u)
#define HDMI_VID_CTRL_ICLK_MASK			(0x00000003u)
#define HDMI_VID_CTRL_ICLK_SHIFT		(0x00000000u)
#define HDMI_VID_ACEN_WIDE_BUS_MASK 		(0x000000C0u)
#define HDMI_VID_ACEN_WIDE_BUS_SHIFT		(0x00000006u)
#define HDMI_VID_ACEN_CLIP_CS_ID_MASK		(0x00000010u)
#define HDMI_VID_ACEN_CLIP_CS_ID_SHIFT		(0x00000004u)
#define HDMI_VID_ACEN_RANGE_CLIP_MASK		(0x00000008u)
#define HDMI_VID_ACEN_RANGE_CLIP_SHIFT		(0x00000003u)
#define HDMI_VID_ACEN_RGB_2_YCBCR_MASK		(0x00000004u)
#define HDMI_VID_ACEN_RGB_2_YCBCR_SHIFT		(0x00000002u)
#define HDMI_VID_ACEN_RANGE_CMPS_MASK		(0x00000002u)
#define HDMI_VID_ACEN_RANGE_CMPS_SHIFT		(0x00000001u)
#define HDMI_VID_ACEN_DOWN_SMPL_MASK		(0x00000001u)
#define HDMI_VID_ACEN_DOWN_SMPL_SHIFT		(0x00000000u)
#define HDMI_VID_MODE_DITHER_MODE_MASK		(0x000000C0u)
#define HDMI_VID_MODE_DITHER_MODE_SHIFT		(0x00000006u)
#define HDMI_VID_MODE_DITHER_MASK		(0x00000020u)
#define HDMI_VID_MODE_DITHER_SHIFT		(0x00000005u)
#define HDMI_VID_MODE_RANGE_MASK		(0x00000010u)
#define HDMI_VID_MODE_RANGE_SHIFT		(0x00000004u)
#define HDMI_VID_MODE_CSC_MASK			(0x00000008u)
#define HDMI_VID_MODE_CSC_SHIFT			(0x00000003u)
#define HDMI_VID_MODE_UPSMP_MASK		(0x00000004u)
#define HDMI_VID_MODE_UPSMP_SHIFT		(0x00000002u)
#define HDMI_VID_MODE_DEMUX_MASK		(0x00000002u)
#define HDMI_VID_MODE_DEMUX_SHIFT		(0x00000001u)
#define HDMI_VID_MODE_SYNCEX_MASK		(0x00000001u)
#define HDMI_VID_MODE_SYNCEX_SHIFT		(0x00000000u)
#define HDMI_DC_HEADER_DC_HEADER_MASK		(0x000000FFu)
#define HDMI_DC_HEADER_DC_HEADER_SHIFT		(0x00000000u)
#define HDMI_DC_HEADER_DC_HEADER_RESETVAL	(0x00000003u)
#define HDMI_VID_DITHER_M_D2_MASK		(0x00000040u)
#define HDMI_VID_DITHER_M_D2_SHIFT		(0x00000006u)
#define HDMI_VID_DITHER_UP2_MASK		(0x00000020u)
#define HDMI_VID_DITHER_UP2_SHIFT		(0x00000005u)
#define HDMI_VID_DITHER_STR_422_EN_MASK		(0x00000010u)
#define HDMI_VID_DITHER_STR_422_EN_SHIFT	(0x00000004u)
#define HDMI_VID_DITHER_D_BC_EN_MASK		(0x00000008u)
#define HDMI_VID_DITHER_D_BC_EN_SHIFT		(0x00000003u)
#define HDMI_VID_DITHER_D_GC_EN_MASK		(0x00000004u)
#define HDMI_VID_DITHER_D_GC_EN_SHIFT		(0x00000002u)
#define HDMI_VID_DITHER_D_RC_EN_MASK		(0x00000002u)
#define HDMI_VID_DITHER_D_RC_EN_SHIFT		(0x00000001u)
#define HDMI_VID_DITHER_DRD_MASK		(0x00000001u)
#define HDMI_VID_DITHER_DRD_SHIFT		(0x00000000u)
#define HDMI_INTR1_SOFT_MASK			(0x00000080u)
#define HDMI_INTR1_SOFT_SHIFT			(0x00000007u)
#define HDMI_INTR1_HPD_MASK			(0x00000040u)
#define HDMI_INTR1_HPD_SHIFT			(0x00000006u)
#define HDMI_INTR1_RSEN_MASK			(0x00000020u)
#define HDMI_INTR1_RSEN_SHIFT			(0x00000005u)
#define HDMI_INTR1_DROP_SAMPLE_MASK		(0x00000010u)
#define HDMI_INTR1_DROP_SAMPLE_SHIFT		(0x00000004u)
#define HDMI_INTR1_BIP_HASE_ERR_MASK		(0x00000008u)
#define HDMI_INTR1_BIP_HASE_ERR_SHIFT		(0x00000003u)
#define HDMI_INTR1_RI_128_MASK			(0x00000004u)
#define HDMI_INTR1_RI_128_SHIFT			(0x00000002u)
#define HDMI_INTR1_OVER_RUN_MASK		(0x00000002u)
#define HDMI_INTR1_OVER_RUN_SHIFT		(0x00000001u)
#define HDMI_INTR1_UNDER_RUN_MASK		(0x00000001u)
#define HDMI_INTR1_UNDER_RUN_SHIFT		(0x00000000u)
#define HDMI_TMDS_CTRL_TCLKSEL_MASK		(0x00000060u)
#define HDMI_TMDS_CTRL_TCLKSEL_SHIFT		(0x00000005u)
#define HDMI_TMDS_CTRL_LVBIAS_MASK		(0x00000004u)
#define HDMI_TMDS_CTRL_LVBIAS_SHIFT		(0x00000002u)
#define HDMI_TMDS_CTRL_STERM_MASK		(0x00000001u)
#define HDMI_TMDS_CTRL_STERM_SHIFT		(0x00000000u)
#define HDMI_XVYCC2RGB_CTL_EXP_ONLY_MASK	(0x00000060u)
#define HDMI_XVYCC2RGB_CTL_EXP_ONLY_SHIFT	(0x00000005u)
#define HDMI_XVYCC2RGB_CTL_BYP_ALL_MASK 	(0x00000018u)
#define HDMI_XVYCC2RGB_CTL_BYP_ALL_SHIFT	(0x00000003u)
#define HDMI_XVYCC2RGB_CTL_SW_OVR_MASK		(0x00000004u)
#define HDMI_XVYCC2RGB_CTL_SW_OVR_SHIFT 	(0x00000002u)
#define HDMI_XVYCC2RGB_CTL_FULLRANGE_MASK	(0x00000002u)
#define HDMI_XVYCC2RGB_CTL_FULLRANGE_SHIFT	(0x00000001u)
#define HDMI_XVYCC2RGB_CTL_XVYCCSEL_MASK	(0x00000001u)
#define HDMI_XVYCC2RGB_CTL_XVYCCSEL_SHIFT	(0x00000000u)
#define HDMI_Y2R_COEFF_LOW_Y2RCOEFF_L_MASK	(0x000000FFu)
#define HDMI_Y2R_COEFF_LOW_Y2RCOEFF_L_SHIFT	(0x00000000u)
#define HDMI_DDC_ADDR_DDC_ADDR_MASK		(0x000000FEu)
#define HDMI_DDC_ADDR_DDC_ADDR_SHIFT		(0x00000001u)
#define HDMI_DDC_SEGM_DDC_SEGM_MASK		(0x000000FFu)
#define HDMI_DDC_SEGM_DDC_SEGM_SHIFT		(0x00000000u)
#define HDMI_DDC_OFFSET_DDC_OFFSET_MASK		(0x000000FFu)
#define HDMI_DDC_OFFSET_DDC_OFFSET_SHIFT	(0x00000000u)
#define HDMI_DDC_COUNT1_DDC_COUNT_MASK		(0x000000FFu)
#define HDMI_DDC_COUNT1_DDC_COUNT_SHIFT		(0x00000000u)
#define HDMI_DDC_COUNT2_DDC_COUNT_MASK		(0x00000003u)
#define HDMI_DDC_COUNT2_DDC_COUNT_SHIFT		(0x00000000u)
#define HDMI_DDC_STATUS_BUS_LOW_MASK		(0x00000040u)
#define HDMI_DDC_STATUS_BUS_LOW_SHIFT		(0x00000006u)
#define HDMI_DDC_STATUS_NO_ACK_MASK		(0x00000020u)
#define HDMI_DDC_STATUS_NO_ACK_SHIFT		(0x00000005u)
#define HDMI_DDC_STATUS_IN_PROG_MASK		(0x00000010u)
#define HDMI_DDC_STATUS_IN_PROG_SHIFT		(0x00000004u)
#define HDMI_DDC_STATUS_FIFO_FULL_MASK		(0x00000008u)
#define HDMI_DDC_STATUS_FIFO_FULL_SHIFT		(0x00000003u)
#define HDMI_DDC_STATUS_FIFO_EMP_MASK		(0x00000004u)
#define HDMI_DDC_STATUS_FIFO_EMP_SHIFT		(0x00000002u)
#define HDMI_DDC_STATUS_FRD_USE_MASK		(0x00000002u)
#define HDMI_DDC_STATUS_FRD_USE_SHIFT		(0x00000001u)
#define HDMI_DDC_STATUS_FWT_USE_MASK		(0x00000001u)
#define HDMI_DDC_STATUS_FWT_USE_SHIFT		(0x00000000u)
#define HDMI_DDC_CMD_DDC_FLT_EN_MASK		(0x00000020u)
#define HDMI_DDC_CMD_DDC_FLT_EN_SHIFT		(0x00000005u)
#define HDMI_DDC_CMD_SDA_DEL_EN_MASK		(0x00000010u)
#define HDMI_DDC_CMD_SDA_DEL_EN_SHIFT		(0x00000004u)
#define HDMI_DDC_CMD_DDC_CMD_MASK		(0x0000000Fu)
#define HDMI_DDC_CMD_DDC_CMD_SHIFT		(0x00000000u)
#define HDMI_DDC_CMD_CLOCK_SCL			(0x0000000Au)
#define HDMI_DDC_CMD_CLEAR_FIFO			(0x00000009u)
#define HDMI_DDC_CMD_SEQ_R_NO_ACK_ON_LAST_BYTE	(0x00000002u)
#define HDMI_DDC_CMD_EDDC_R_NO_ACK_ON_LAST_BYTE (0x00000004u)
#define HDMI_DDC_CMD_ABORT			(0x0000000Fu)
#define HDMI_DDC_DATA_DDC_DATA_MASK		(0x000000FFu)
#define HDMI_ACR_CTRL_NCTSPKT_EN_MASK		(0x00000030u)
#define HDMI_ACR_CTRL_NCTSPKT_EN_SHIFT		(0x00000004u)
#define HDMI_ACR_CTRL_CTS_SEL_MASK		(0x0000000Fu)
#define HDMI_ACR_CTRL_CTS_SEL_SHIFT		(0x00000000u)
#define HDMI_AUD_MODE_SD3_EN_MASK		(0x00000080u)
#define HDMI_AUD_MODE_SD3_EN_SHIFT		(0x00000007u)
#define HDMI_AUD_MODE_SD2_EN_MASK		(0x00000040u)
#define HDMI_AUD_MODE_SD2_EN_SHIFT		(0x00000006u)
#define HDMI_AUD_MODE_SD1_EN_MASK		(0x00000020u)
#define HDMI_AUD_MODE_SD1_EN_SHIFT		(0x00000005u)
#define HDMI_AUD_MODE_SD0_EN_MASK		(0x00000010u)
#define HDMI_AUD_MODE_SD0_EN_SHIFT		(0x00000004u)
#define HDMI_AUD_MODE_DSD_EN_MASK		(0x00000008u)
#define HDMI_AUD_MODE_DSD_EN_SHIFT		(0x00000003u)
#define HDMI_AUD_MODE_AUD_PAR_EN_MASK		(0x00000004u)
#define HDMI_AUD_MODE_AUD_PAR_EN_SHIFT		(0x00000002u)
#define HDMI_AUD_MODE_SPDIF_EN_MASK		(0x00000002u)
#define HDMI_AUD_MODE_SPDIF_EN_SHIFT		(0x00000001u)
#define HDMI_AUD_MODE_AUD_EN_MASK		(0x00000001u)
#define HDMI_AUD_MODE_AUD_EN_SHIFT		(0x00000000u)
#define HDMI_HDMI_CTRL_DC_EN_MASK		(0x00000040u)
#define HDMI_HDMI_CTRL_DC_EN_SHIFT		(0x00000006u)
#define HDMI_HDMI_CTRL_PACKET_MODE_MASK		(0x00000038u)
#define HDMI_HDMI_CTRL_PACKET_MODE_SHIFT	(0x00000003u)
#define HDMI_HDMI_CTRL_LAYOUT_MASK		(0x00000006u)
#define HDMI_HDMI_CTRL_LAYOUT_SHIFT		(0x00000001u)
#define HDMI_HDMI_CTRL_HDMI_MODE_MASK		(0x00000001u)
#define HDMI_HDMI_CTRL_HDMI_MODE_SHIFT		(0x00000000u)
#define HDMI_TEST_TXCTRL_DIV_ENC_BYP_MASK	(0x00000008u)
#define HDMI_TEST_TXCTRL_DIV_ENC_BYP_SHIFT	(0x00000003u)
#define HDMI_TEST_TXCTRL_CORE_ISO_EN_MASK	(0x00000004u)
#define HDMI_TEST_TXCTRL_CORE_ISO_EN_SHIFT	(0x00000002u)
#define HDMI_PB_CTRL1_MPEG_EN_MASK		(0x00000080u)
#define HDMI_PB_CTRL1_MPEG_EN_SHIFT		(0x00000007u)
#define HDMI_PB_CTRL1_MPEG_RPT_MASK		(0x00000040u)
#define HDMI_PB_CTRL1_MPEG_RPT_SHIFT		(0x00000006u)
#define HDMI_PB_CTRL1_AUD_EN_MASK		(0x00000020u)
#define HDMI_PB_CTRL1_AUD_EN_SHIFT		(0x00000005u)
#define HDMI_PB_CTRL1_AUD_RPT_MASK		(0x00000010u)
#define HDMI_PB_CTRL1_AUD_RPT_SHIFT		(0x00000004u)
#define HDMI_PB_CTRL1_SPD_EN_MASK		(0x00000008u)
#define HDMI_PB_CTRL1_SPD_EN_SHIFT		(0x00000003u)
#define HDMI_PB_CTRL1_SPD_RPT_MASK		(0x00000004u)
#define HDMI_PB_CTRL1_SPD_RPT_SHIFT		(0x00000002u)
#define HDMI_PB_CTRL1_AVI_EN_MASK		(0x00000002u)
#define HDMI_PB_CTRL1_AVI_EN_SHIFT		(0x00000001u)
#define HDMI_PB_CTRL1_AVI_RPT_MASK		(0x00000001u)
#define HDMI_PB_CTRL1_AVI_RPT_SHIFT		(0x00000000u)
#define HDMI_PB_CTRL2_GAM_EN_MASK		(0x00000080u)
#define HDMI_PB_CTRL2_GAM_EN_SHIFT		(0x00000007u)
#define HDMI_PB_CTRL2_GAM_RPT_MASK		(0x00000040u)
#define HDMI_PB_CTRL2_GAM_RPT_SHIFT		(0x00000006u)
#define HDMI_PB_CTRL2_GEN2_EN_MASK		(0x00000020u)
#define HDMI_PB_CTRL2_GEN2_EN_SHIFT		(0x00000005u)
#define HDMI_PB_CTRL2_GEN2_RPT_MASK		(0x00000010u)
#define HDMI_PB_CTRL2_GEN2_RPT_SHIFT		(0x00000004u)
#define HDMI_PB_CTRL2_CP_EN_MASK		(0x00000008u)
#define HDMI_PB_CTRL2_CP_EN_SHIFT		(0x00000003u)
#define HDMI_PB_CTRL2_CP_RPT_MASK		(0x00000004u)
#define HDMI_PB_CTRL2_CP_RPT_SHIFT		(0x00000002u)
#define HDMI_PB_CTRL2_GEN_EN_MASK		(0x00000002u)
#define HDMI_PB_CTRL2_GEN_EN_SHIFT		(0x00000001u)
#define HDMI_PB_CTRL2_GEN_RPT_MASK		(0x00000001u)
#define HDMI_PB_CTRL2_GEN_RPT_SHIFT		(0x00000000u)
#define HDMI_AVI_TYPE_AVI_TYPE_MASK		(0x000000FFu)
#define HDMI_AVI_TYPE_AVI_TYPE_SHIFT		(0x00000000u)
#define HDMI_AVI_VERS_AVI_VERS_MASK		(0x000000FFu)
#define HDMI_AVI_VERS_AVI_VERS_SHIFT		(0x00000000u)
#define HDMI_AVI_LEN_AVI_LEN_MASK		(0x000000FFu)
#define HDMI_AVI_LEN_AVI_LEN_SHIFT		(0x00000000u)
#define HDMI_AVI_CHSUM_AVI_CHSUM_MASK		(0x000000FFu)
#define HDMI_AVI_CHSUM_AVI_CHSUM_SHIFT		(0x00000000u)
#define HDMI_AVI_DBYTE_AVI_DATA_MASK		(0x000000FFu)
#define HDMI_AVI_DBYTE_AVI_DATA_SHIFT		(0x00000000u)
#define HDMI_CP_BYTE1_CLRAVM_MASK		(0x00000010u)
#define HDMI_CP_BYTE1_CLRAVM_SHIFT		(0x00000004u)
#define HDMI_CP_BYTE1_SETAVM_MASK		(0x00000010u)
#define HDMI_CP_BYTE1_SETAVM_SHIFT		(0x00000004u)
/************************************CORE**************************************/
/************************************PRCM**************************************/
#ifdef CONFIG_ARCH_TI816X
#define CM_HDMI_CLKSTCTRL_OFF			(0x0408)
#define CM_ACTIVE_HDMI_CLKCTRL_OFF		(0x0428)
#else
#define CM_HDMI_CLKCTRL_OFF             (0x0824)
#define CM_ALWON_SDIO_CLKCTRL           (0x15B0)
#define HDMI_PLL_BASE_ADDR              (0x481C5200)
#define HDMI_PLL_CLKCTRL_OFF			0x4
#define HDMI_PLL_TENABLE_OFF			0x8
#define HDMI_PLL_TENABLEDIV_OFF			0xC
#define HDMI_PLL_M2NDIV_OFF		    	0x10
#define HDMI_PLL_MN2DIV_OFF		        0x14
#define HDMI_PLL_STATUS_OFF		        0x24
//#define
#endif

