/*
 * ti81xx family interrupts.
 *
 * Copyright (C) 2010 Texas Instruments, Inc. - http://www.ti.com/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_TI81XX_IRQS_H
#define __ARCH_ARM_MACH_OMAP2_TI81XX_IRQS_H

/*
 * TI81XX Interrupts. Note that some interrupts are specific to TI81XX or TI814X
 * as indicated by respective prefix.
 */
#define TI81XX_IRQ_EMU		0
#define TI81XX_IRQ_COMMTX	1
#define TI81XX_IRQ_COMMRX	2
#define TI81XX_IRQ_BENCH	3
#define TI81XX_IRQ_ELM		4
#define TI81XX_IRQ_SSM_WFI	5
#define TI81XX_IRQ_SSM		6
#define TI81XX_IRQ_NMI		7
#define TI81XX_IRQ_SEC_EVNT	8
#define TI81XX_IRQ_L3_DEBUG	9
#define TI81XX_IRQ_L3_APP	10
#define TI814X_IRQ_GPT8		11
#define TI81XX_IRQ_EDMA_COMP	12
#define TI81XX_IRQ_EDMA_MPERR	13
#define TI81XX_IRQ_EDMA_ERR	14
#define TI814X_IRQ_WDT0		15
#define TI81XX_IRQ_SATA		16
#define TI81XX_IRQ_USBSS	17
#define TI81XX_IRQ_USB0		18
#define TI81XX_IRQ_USB1		19
#define TI81XX_IRQ_TPPSS_ERR	20
#define TI81XX_IRQ_TPPSS_MBOX	21
#define TI81XX_IRQ_TPPSS_STC0	22
#define TI81XX_IRQ_TPPSS_STC1	23
#define TI81XX_IRQ_TPPSS_DMAPC0	24
#define TI81XX_IRQ_TPPSS_DMABS0	25
#define TI81XX_IRQ_TPPSS_ERR0	26
#define TI81XX_IRQ_TPPSS_ERR1	27
#define TI816X_IRQ_TPPSS_ERR2	28
#define TI814X_IRQ_SD1		28
#define TI816X_IRQ_TPPSS_ERR3	29
#define TI814X_IRQ_SD2		29
#define TI816X_IRQ_MCARD_TX	30
#define TI814X_IRQ_I2C2		30
#define TI816X_IRQ_MCARD_RX	31
#define TI814X_IRQ_I2C3		31
#define TI814X_IRQ_GPIO_2A	32
#define TI814X_IRQ_GPIO_2B	33
#define TI81XX_IRQ_USB_WKUP	34
#define TI81XX_IRQ_PCIE_WKUP	35
#define TI81XX_IRQ_DSSINT	36
#define TI81XX_IRQ_GFXINT	37
#define TI81XX_IRQ_HDMIINT	38
#define TI816X_IRQ_VLYNQ	39
#define TI814X_IRQ_ISS		39	/* Actually ISS_IRQ4 */
#define TI816X_IRQ_MACRXTHR0	40
#define TI814X_IRQ_GSWRXTHR0	40
#define TI816X_IRQ_MACRXINT0	41
#define TI814X_IRQ_GSWRXINT0	41
#define TI816X_IRQ_MACTXINT0	42
#define TI814X_IRQ_GSWTXINT0	42
#define TI816X_IRQ_MACMISC0	43
#define TI814X_IRQ_GSWMISC0	43
#define TI816X_IRQ_MACRXTHR1	44
#define TI814X_IRQ_UART3	44
#define TI816X_IRQ_MACRXINT1	45
#define TI814X_IRQ_UART4	45
#define TI816X_IRQ_MACTXINT1	46
#define TI814X_IRQ_UART5	46
#define TI816X_IRQ_MACMISC1	47
#define TI814X_IRQ_FDIF		47	/* Actually FDIF_IRQ3 */
#define TI81XX_IRQ_PCIINT0	48
#define TI81XX_IRQ_PCIINT1	49
#define TI81XX_IRQ_PCIINT2	50
#define TI81XX_IRQ_PCIINT3	51
#define TI814X_IRQ_DCAN0_INT0	52
#define TI814X_IRQ_DCAN0_INT1	53
#define TI814X_IRQ_DCAN0_PAR	54
#define TI814X_IRQ_DCAN1_INT0	55
#define TI814X_IRQ_DCAN1_INT1	56
#define TI814X_IRQ_DCAN1_PAR	57
#define TI814X_IRQ_MLB_SYSINT0	58
#define TI814X_IRQ_MLB_SYSINT1	59
#define TI814X_IRQ_MLB_INT	60
#define TI814X_IRQ_VCP_INT	61
#define TI814X_IRQ_GPIO_3A	62
#define TI814X_IRQ_GPIO_3B	63
#define TI81XX_IRQ_SD		64	/* TI814X SD0 */
#define TI81XX_IRQ_SPI		65	/* TI814X McSPI0 */
#define TI81XX_IRQ_GPT1		67
#define TI81XX_IRQ_GPT2		68
#define TI81XX_IRQ_GPT3		69
#define TI81XX_IRQ_I2C0		70
#define TI81XX_IRQ_I2C1		71
#define TI81XX_IRQ_UART0	72
#define TI81XX_IRQ_UART1	73
#define TI81XX_IRQ_UART2	74
#define TI81XX_IRQ_RTC		75
#define TI81XX_IRQ_RTC_ALARM	76
#define TI81XX_IRQ_MBOX		77
#define TI814X_IRQ_IDE		78
#define TI81XX_IRQ_MCASP0_TX	80
#define TI81XX_IRQ_MCASP0_RX	81
#define TI81XX_IRQ_MCASP1_TX	82
#define TI81XX_IRQ_MCASP1_RX	83
#define TI81XX_IRQ_MCASP2_TX	84
#define TI81XX_IRQ_MCASP2_RX	85
#define TI81XX_IRQ_MCBSP	86
#define TI81XX_IRQ_SMCD0	87
#define TI81XX_IRQ_SMCD1	88
#define TI814X_IRQ_SMRFLX2	89
#define TI814X_IRQ_SMRFLX3	90
#define TI81XX_IRQ_WDT1		91
#define TI81XX_IRQ_GPT4		92
#define TI81XX_IRQ_GPT5		93
#define TI81XX_IRQ_GPT6		94
#define TI81XX_IRQ_GPT7		95
#define TI81XX_IRQ_GPIO_0A	96
#define TI81XX_IRQ_GPIO_0B	97
#define TI81XX_IRQ_GPIO_1A	98
#define TI81XX_IRQ_GPIO_1B	99
#define TI81XX_IRQ_GPMC		100
#define TI81XX_IRQ_DDR_ERR0	101
#define TI81XX_IRQ_DDR_ERR1	102
#define TI81XX_IRQ_IVA0CONT1SYNC	103
#define TI81XX_IRQ_IVA0CONT2SYNC	104
#define TI8XXX16X_IRQ_IVA1CONT1SYNC	105
#define TI814X_IRQ_MCASP3_TX	105
#define TI816X_IRQ_IVA1CONT2SYNC	106
#define TI814X_IRQ_MCASP3_RX	106
#define TI81XX_IRQ_IVA0MBOX	107
#define TI816X_IRQ_IVA1MBOX	108
#define TI814X_IRQ_MCASP4_TX	108
#define TI816X_IRQ_IVA2MBOX	109
#define TI814X_IRQ_MCASP4_RX	109
#define TI816X_IRQ_IVA2CONT1SYNC	110
#define TI814X_IRQ_MCASP5_TX	110
#define TI816X_IRQ_IVA2CONT2SYNC	111
#define TI814X_IRQ_MCASP5_RX	111
#define TI81XX_IRQ_TPTC0	112
#define TI81XX_IRQ_TPTC1	113
#define TI81XX_IRQ_TPTC2	114
#define TI81XX_IRQ_TPTC3	115
#define TI81XX_IRQ_SECPUBINT	116
#define TI81XX_IRQ_SECSECINT	117
#define TI81XX_IRQ_SECPUBSWINT	118
#define TI81XX_IRQ_SECSECSWINT	119
#define TI81XX_IRQ_SMRFLX0	120
#define TI81XX_IRQ_SMRFLX1	121
#define TI81XX_IRQ_SYS_MMU	122
#define TI81XX_IRQ_MC_MMU	123
#define TI81XX_IRQ_DMM		124
#define TI814X_IRQ_SPI1		125
#define TI814X_IRQ_SPI2		126
#define TI814X_IRQ_SPI3		127

#endif
