/*
 * TI816x pad control register macros.
 *
 * Copyright (C) 2010 Texas Instruments, Inc. - http://www.ti.com/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_MUX816X_H
#define __ARCH_ARM_MACH_OMAP2_MUX816X_H

#define TI81XX_CONTROL_PADCONF_MUX_PBASE			0x48140000LU

#define TI816X_MUX(mode0, mux_value)					\
{									\
	.reg_offset	= (TI816X_CONTROL_PADCONF_##mode0##_OFFSET),	\
	.value		= (mux_value),					\
}

/*
 * TI816X CONTROL_PADCONF* register offsets for pin-muxing
 *
 * Extracted from the spec. Add TI816X_CONTROL_PADCONF_MUX_PBASE to these values
 * to get the absolute addresses. The macro names below are mode-0 names of
 * corresponding pins.
 */
#define TI816X_CONTROL_PADCONF_TSI0_DCLK_OFFSET			0x0800
#define TI816X_CONTROL_PADCONF_TSI0_DATA_OFFSET			0x0804
#define TI816X_CONTROL_PADCONF_TSI0_BYTSTRT_OFFSET		0x0808
#define TI816X_CONTROL_PADCONF_TSI0_PACVAL_OFFSET		0x080C
#define TI816X_CONTROL_PADCONF_TSI0_PACERR_OFFSET		0x0810
#define TI816X_CONTROL_PADCONF_TSI1_DCLK_OFFSET			0x0814
#define TI816X_CONTROL_PADCONF_TSI1_DATA_OFFSET			0x0818
#define TI816X_CONTROL_PADCONF_TSI1_BYTSTRT_OFFSET		0x081C
#define TI816X_CONTROL_PADCONF_TSI1_PACVAL_OFFSET		0x0820
#define TI816X_CONTROL_PADCONF_TSI1_PACERR_OFFSET		0x0824
#define TI816X_CONTROL_PADCONF_TSI2_DCLK_OFFSET			0x0828
#define TI816X_CONTROL_PADCONF_TSI2_DATA_OFFSET			0x082C
#define TI816X_CONTROL_PADCONF_TSI2_BYTSTRT_OFFSET		0x0830
#define TI816X_CONTROL_PADCONF_TSI2_PACVAL_OFFSET		0x0834
#define TI816X_CONTROL_PADCONF_TSI2_PACERR_OFFSET		0x0838
#define TI816X_CONTROL_PADCONF_TSI3_DCLK_OFFSET			0x083C
#define TI816X_CONTROL_PADCONF_TSI3_DATA_OFFSET			0x0840
#define TI816X_CONTROL_PADCONF_TSI3_BYTSTRT_OFFSET		0x0844
#define TI816X_CONTROL_PADCONF_TSI3_PACVAL_OFFSET		0x0848
#define TI816X_CONTROL_PADCONF_TSI3_PACERR_OFFSET		0x084C
#define TI816X_CONTROL_PADCONF_TSI4_DCLK_OFFSET			0x0850
#define TI816X_CONTROL_PADCONF_TSI4_DATA_OFFSET			0x0854
#define TI816X_CONTROL_PADCONF_TSI4_BYTSTRT_OFFSET		0x0858
#define TI816X_CONTROL_PADCONF_TSI4_PACVAL_OFFSET		0x085C
#define TI816X_CONTROL_PADCONF_TSI4_PACERR_OFFSET		0x0860
#define TI816X_CONTROL_PADCONF_TSI5_DCLK_OFFSET			0x0864
#define TI816X_CONTROL_PADCONF_TSI5_DATA_OFFSET			0x0868
#define TI816X_CONTROL_PADCONF_TSI5_BYTSTRT_OFFSET		0x086C
#define TI816X_CONTROL_PADCONF_TSI5_PACVAL_OFFSET		0x0870
#define TI816X_CONTROL_PADCONF_TSI5_PACERR_OFFSET		0x0874
#define TI816X_CONTROL_PADCONF_TSI6_DCLK_OFFSET			0x0878
#define TI816X_CONTROL_PADCONF_TSI6_DATA_OFFSET			0x087C
#define TI816X_CONTROL_PADCONF_TSI6_BYTSTRT_OFFSET		0x0880
#define TI816X_CONTROL_PADCONF_TSI6_PACVAL_OFFSET		0x0884
#define TI816X_CONTROL_PADCONF_TSI6_PACERR_OFFSET		0x0888
#define TI816X_CONTROL_PADCONF_TSI7_DCLK_OFFSET			0x088C
#define TI816X_CONTROL_PADCONF_TSI7_DATA_OFFSET			0x0890
#define TI816X_CONTROL_PADCONF_TSI7_BYTSTRT_OFFSET		0x0894
#define TI816X_CONTROL_PADCONF_TSI7_PACVAL_OFFSET		0x0898
#define TI816X_CONTROL_PADCONF_TSI7_PACERR_OFFSET		0x089C
#define TI816X_CONTROL_PADCONF_TSO0_DCLK_OFFSET			0x08A0
#define TI816X_CONTROL_PADCONF_TSO0_DATA_OFFSET			0x08A4
#define TI816X_CONTROL_PADCONF_TSO0_BYTSTRT_OFFSET		0x08A8
#define TI816X_CONTROL_PADCONF_TSO0_PACVAL_OFFSET		0x08AC
#define TI816X_CONTROL_PADCONF_TSO0_PACERR_OFFSET		0x08B0
#define TI816X_CONTROL_PADCONF_TSO1_DCLK_OFFSET			0x08B4
#define TI816X_CONTROL_PADCONF_TSO1_DATA_OFFSET			0x08B8
#define TI816X_CONTROL_PADCONF_TSO1_BYTSTRT_OFFSET		0x08BC
#define TI816X_CONTROL_PADCONF_TSO1_PACVAL_OFFSET		0x08C0
#define TI816X_CONTROL_PADCONF_TSO1_PACERR_OFFSET		0x08C4
#define TI816X_CONTROL_PADCONF_MTSI_DCLK_OFFSET			0x08C8
#define TI816X_CONTROL_PADCONF_MTSI_DATA0_OFFSET		0x08CC
#define TI816X_CONTROL_PADCONF_MTSI_DATA1_OFFSET		0x08D0
#define TI816X_CONTROL_PADCONF_MTSI_DATA2_OFFSET		0x08D4
#define TI816X_CONTROL_PADCONF_MTSI_DATA3_OFFSET		0x08D8
#define TI816X_CONTROL_PADCONF_MTSI_DATA4_OFFSET		0x08DC
#define TI816X_CONTROL_PADCONF_MTSI_DATA5_OFFSET		0x08E0
#define TI816X_CONTROL_PADCONF_MTSI_DATA6_OFFSET		0x08E4
#define TI816X_CONTROL_PADCONF_MTSI_DATA7_OFFSET		0x08E8
#define TI816X_CONTROL_PADCONF_MTSI_BYTSTRT_OFFSET		0x08EC
#define TI816X_CONTROL_PADCONF_MTSO_DCLK_OFFSET			0x08F0
#define TI816X_CONTROL_PADCONF_MTSO_DATA0_OFFSET		0x08F4
#define TI816X_CONTROL_PADCONF_MTSO_DATA1_OFFSET		0x08F8
#define TI816X_CONTROL_PADCONF_MTSO_DATA2_OFFSET		0x08FC
#define TI816X_CONTROL_PADCONF_MTSO_DATA3_OFFSET		0x0900
#define TI816X_CONTROL_PADCONF_MTSO_DATA4_OFFSET		0x0904
#define TI816X_CONTROL_PADCONF_MTSO_DATA5_OFFSET		0x0908
#define TI816X_CONTROL_PADCONF_MTSO_DATA6_OFFSET		0x090C
#define TI816X_CONTROL_PADCONF_MTSO_DATA7_OFFSET		0x0910
#define TI816X_CONTROL_PADCONF_MTSO_BYTSTRT_OFFSET		0x0914
#define TI816X_CONTROL_PADCONF_MCTL_SCLK_OFFSET			0x0918
#define TI816X_CONTROL_PADCONF_MCTL_SCTL_OFFSET			0x091C
#define TI816X_CONTROL_PADCONF_MCTL_SDI_OFFSET			0x0920
#define TI816X_CONTROL_PADCONF_MCTL_SDO_OFFSET			0x0924
#define TI816X_CONTROL_PADCONF_MCARD_MDET_OFFSET		0x0928
#define TI816X_CONTROL_PADCONF_MCARD_CD1_OFFSET			0x092C
#define TI816X_CONTROL_PADCONF_MCARD_CD2_OFFSET			0x0930
#define TI816X_CONTROL_PADCONF_MCARD_VS1_OFFSET			0x0934
#define TI816X_CONTROL_PADCONF_MCARD_VS2_OFFSET			0x0938
#define TI816X_CONTROL_PADCONF_MCARD_VCCEN_OFFSET		0x093C
#define TI816X_CONTROL_PADCONF_MCARD_VPPEN_OFFSET		0x0940
#define TI816X_CONTROL_PADCONF_MCARD_RESET_OFFSET		0x0944
#define TI816X_CONTROL_PADCONF_VIN0_CLK0_OFFSET			0x0948
#define TI816X_CONTROL_PADCONF_VIN0_CLK1_OFFSET			0x094C
#define TI816X_CONTROL_PADCONF_VIN0_D0_OFFSET			0x0950
#define TI816X_CONTROL_PADCONF_VIN0_D1_OFFSET			0x0954
#define TI816X_CONTROL_PADCONF_VIN0_D2_OFFSET			0x0958
#define TI816X_CONTROL_PADCONF_VIN0_D3_OFFSET			0x095C
#define TI816X_CONTROL_PADCONF_VIN0_D4_OFFSET			0x0960
#define TI816X_CONTROL_PADCONF_VIN0_D5_OFFSET			0x0964
#define TI816X_CONTROL_PADCONF_VIN0_D6_OFFSET			0x0968
#define TI816X_CONTROL_PADCONF_VIN0_D7_OFFSET			0x096C
#define TI816X_CONTROL_PADCONF_VIN0_D8_OFFSET			0x0970
#define TI816X_CONTROL_PADCONF_VIN0_D9_OFFSET			0x0974
#define TI816X_CONTROL_PADCONF_VIN0_D10_OFFSET			0x0978
#define TI816X_CONTROL_PADCONF_VIN0_D11_OFFSET			0x097C
#define TI816X_CONTROL_PADCONF_VIN0_D12_OFFSET			0x0980
#define TI816X_CONTROL_PADCONF_VIN0_D13_OFFSET			0x0984
#define TI816X_CONTROL_PADCONF_VIN0_D14_OFFSET			0x0988
#define TI816X_CONTROL_PADCONF_VIN0_D15_OFFSET			0x098C
#define TI816X_CONTROL_PADCONF_VOUT0_CLK_OFFSET			0x0990
#define TI816X_CONTROL_PADCONF_VOUT0_G_Y_YC2_OFFSET		0x0994
#define TI816X_CONTROL_PADCONF_VOUT0_G_Y_YC3_OFFSET		0x0998
#define TI816X_CONTROL_PADCONF_VOUT0_G_Y_YC4_OFFSET		0x099C
#define TI816X_CONTROL_PADCONF_VOUT0_G_Y_YC5_OFFSET		0x09A0
#define TI816X_CONTROL_PADCONF_VOUT0_G_Y_YC6_OFFSET		0x09A4
#define TI816X_CONTROL_PADCONF_VOUT0_G_Y_YC7_OFFSET		0x09A8
#define TI816X_CONTROL_PADCONF_VOUT0_G_Y_YC8_OFFSET		0x09AC
#define TI816X_CONTROL_PADCONF_VOUT0_G_Y_YC9_OFFSET		0x09B0
#define TI816X_CONTROL_PADCONF_VOUT0_B_CB_C2_OFFSET		0x09B4
#define TI816X_CONTROL_PADCONF_VOUT0_B_CB_C3_OFFSET		0x09B8
#define TI816X_CONTROL_PADCONF_VOUT0_B_CB_C4_OFFSET		0x09BC
#define TI816X_CONTROL_PADCONF_VOUT0_B_CB_C5_OFFSET		0x09C0
#define TI816X_CONTROL_PADCONF_VOUT0_B_CB_C6_OFFSET		0x09C4
#define TI816X_CONTROL_PADCONF_VOUT0_B_CB_C7_OFFSET		0x09C8
#define TI816X_CONTROL_PADCONF_VOUT0_B_CB_C8_OFFSET		0x09CC
#define TI816X_CONTROL_PADCONF_VOUT0_B_CB_C9_OFFSET		0x09D0
#define TI816X_CONTROL_PADCONF_VOUT0_R_CR2_OFFSET		0x09D4
#define TI816X_CONTROL_PADCONF_VOUT0_R_CR3_OFFSET		0x09D8
#define TI816X_CONTROL_PADCONF_VOUT0_R_CR4_OFFSET		0x09DC
#define TI816X_CONTROL_PADCONF_VOUT0_R_CR5_OFFSET		0x09E0
#define TI816X_CONTROL_PADCONF_VOUT0_R_CR6_OFFSET		0x09E4
#define TI816X_CONTROL_PADCONF_VOUT0_R_CR7_OFFSET		0x09E8
#define TI816X_CONTROL_PADCONF_VOUT0_R_CR8_OFFSET		0x09EC
#define TI816X_CONTROL_PADCONF_VOUT0_R_CR9_OFFSET		0x09F0
#define TI816X_CONTROL_PADCONF_MCA0_ACLKR_OFFSET		0x09F4
#define TI816X_CONTROL_PADCONF_MCA0_AHCLKR_OFFSET		0x09F8
#define TI816X_CONTROL_PADCONF_MCA0_AFSR_OFFSET			0x09FC
#define TI816X_CONTROL_PADCONF_MCA0_ACLKX_OFFSET		0x0A00
#define TI816X_CONTROL_PADCONF_MCA0_ACLKHX_OFFSET		0x0A04
#define TI816X_CONTROL_PADCONF_MCA0_AFSX_OFFSET			0x0A08
#define TI816X_CONTROL_PADCONF_MCA0_AMUTE_OFFSET		0x0A0C
#define TI816X_CONTROL_PADCONF_MCA0_AXR0_OFFSET			0x0A10
#define TI816X_CONTROL_PADCONF_MCA0_AXR1_OFFSET			0x0A14
#define TI816X_CONTROL_PADCONF_MCA0_AXR2_OFFSET			0x0A18
#define TI816X_CONTROL_PADCONF_MCA0_AXR3_OFFSET			0x0A1C
#define TI816X_CONTROL_PADCONF_MCA0_AXR4_OFFSET			0x0A20
#define TI816X_CONTROL_PADCONF_MCA0_AXR5_OFFSET			0x0A24
#define TI816X_CONTROL_PADCONF_MCA1_ACLKR_OFFSET		0x0A28
#define TI816X_CONTROL_PADCONF_MCA1_AHCLKR_OFFSET		0x0A2C
#define TI816X_CONTROL_PADCONF_MCA1_AFSR_OFFSET			0x0A30
#define TI816X_CONTROL_PADCONF_MCA1_ACLKX_OFFSET		0x0A34
#define TI816X_CONTROL_PADCONF_MCA1_ACLKHX_OFFSET		0x0A38
#define TI816X_CONTROL_PADCONF_MCA1_AFSX_OFFSET			0x0A3C
#define TI816X_CONTROL_PADCONF_MCA1_AMUTE_OFFSET		0x0A40
#define TI816X_CONTROL_PADCONF_MCA1_AXR0_OFFSET			0x0A44
#define TI816X_CONTROL_PADCONF_MCA1_AXR1_OFFSET			0x0A48
#define TI816X_CONTROL_PADCONF_MCA2_ACLKR_OFFSET		0x0A4C
#define TI816X_CONTROL_PADCONF_MCA2_AHCLKR_OFFSET		0x0A50
#define TI816X_CONTROL_PADCONF_MCA2_AFSR_OFFSET			0x0A54
#define TI816X_CONTROL_PADCONF_MCA2_ACLKX_OFFSET		0x0A58
#define TI816X_CONTROL_PADCONF_MCA2_ACLKHX_OFFSET		0x0A5C
#define TI816X_CONTROL_PADCONF_MCA2_AFSX_OFFSET			0x0A60
#define TI816X_CONTROL_PADCONF_MCA2_AMUTE_OFFSET		0x0A64
#define TI816X_CONTROL_PADCONF_MCA2_AXR0_OFFSET			0x0A68
#define TI816X_CONTROL_PADCONF_MCA2_AXR1_OFFSET			0x0A6C
#define TI816X_CONTROL_PADCONF_MMC_POW_OFFSET			0x0A70
#define TI816X_CONTROL_PADCONF_MMC_CLK_OFFSET			0x0A74
#define TI816X_CONTROL_PADCONF_MMC_CMD_OFFSET			0x0A78
#define TI816X_CONTROL_PADCONF_MMC_DAT0_OFFSET			0x0A7C
#define TI816X_CONTROL_PADCONF_MMC_DAT1_SDIRQ_OFFSET		0x0A80
#define TI816X_CONTROL_PADCONF_MMC_DAT2_SDRW_OFFSET		0x0A84
#define TI816X_CONTROL_PADCONF_MMC_DAT3_OFFSET			0x0A88
#define TI816X_CONTROL_PADCONF_MMC_SDCD_OFFSET			0x0A8C
#define TI816X_CONTROL_PADCONF_MMC_SDWP_OFFSET			0x0A90
#define TI816X_CONTROL_PADCONF_SPI_SCLK_OFFSET			0x0A94
#define TI816X_CONTROL_PADCONF_SPI_SCS0_OFFSET			0x0A98
#define TI816X_CONTROL_PADCONF_SPI_SCS1_OFFSET			0x0A9C
#define TI816X_CONTROL_PADCONF_SPI_SCS2_OFFSET			0x0AA0
#define TI816X_CONTROL_PADCONF_SPI_SCS3_OFFSET			0x0AA4
#define TI816X_CONTROL_PADCONF_SPI_D0_OFFSET			0x0AA8
#define TI816X_CONTROL_PADCONF_SPI_D1_OFFSET			0x0AAC
#define TI816X_CONTROL_PADCONF_UART0_RXD_OFFSET			0x0AB0
#define TI816X_CONTROL_PADCONF_UART0_TXD_OFFSET			0x0AB4
#define TI816X_CONTROL_PADCONF_UART0_RTSN_OFFSET		0x0AB8
#define TI816X_CONTROL_PADCONF_UART0_CTSN_OFFSET		0x0ABC
#define TI816X_CONTROL_PADCONF_UART0_DTRN_OFFSET		0x0AC0
#define TI816X_CONTROL_PADCONF_UART0_DSRN_OFFSET		0x0AC4
#define TI816X_CONTROL_PADCONF_UART0_DCDN_OFFSET		0x0AC8
#define TI816X_CONTROL_PADCONF_UART0_RIN_OFFSET			0x0ACC
#define TI816X_CONTROL_PADCONF_UART1_RXD_OFFSET			0x0AD0
#define TI816X_CONTROL_PADCONF_UART1_TXD_OFFSET			0x0AD4
#define TI816X_CONTROL_PADCONF_UART1_RTSN_OFFSET		0x0AD8
#define TI816X_CONTROL_PADCONF_UART1_CTSN_OFFSET		0x0ADC
#define TI816X_CONTROL_PADCONF_UART2_RXD_OFFSET			0x0AE0
#define TI816X_CONTROL_PADCONF_UART2_TXD_OFFSET			0x0AE4
#define TI816X_CONTROL_PADCONF_UART2_RTSN_OFFSET		0x0AE8
#define TI816X_CONTROL_PADCONF_UART2_CTSN_OFFSET		0x0AEC
#define TI816X_CONTROL_PADCONF_SC0_DET_OFFSET			0x0AF0
#define TI816X_CONTROL_PADCONF_SC0_RST_OFFSET			0x0AF4
#define TI816X_CONTROL_PADCONF_SC0_CLK_OFFSET			0x0AF8
#define TI816X_CONTROL_PADCONF_SC0_DATA_OFFSET			0x0AFC
#define TI816X_CONTROL_PADCONF_SC0_C4_OFFSET			0x0B00
#define TI816X_CONTROL_PADCONF_SC0_VCCEN_OFFSET			0x0B04
#define TI816X_CONTROL_PADCONF_SC0_VPPEN_OFFSET			0x0B08
#define TI816X_CONTROL_PADCONF_SC1_DET_OFFSET			0x0B0C
#define TI816X_CONTROL_PADCONF_SC1_RST_OFFSET			0x0B10
#define TI816X_CONTROL_PADCONF_SC1_CLK_OFFSET			0x0B14
#define TI816X_CONTROL_PADCONF_SC1_DATA_OFFSET			0x0B18
#define TI816X_CONTROL_PADCONF_SC1_C4_OFFSET			0x0B1C
#define TI816X_CONTROL_PADCONF_SC1_VCCEN_OFFSET			0x0B20
#define TI816X_CONTROL_PADCONF_SC1_VPPEN_OFFSET			0x0B24
#define TI816X_CONTROL_PADCONF_TIM4_OUT_OFFSET			0x0B28
#define TI816X_CONTROL_PADCONF_TIM5_OUT_OFFSET			0x0B2C
#define TI816X_CONTROL_PADCONF_TIM6_OUT_OFFSET			0x0B30
#define TI816X_CONTROL_PADCONF_TIM7_OUT_OFFSET			0x0B34
#define TI816X_CONTROL_PADCONF_GPMC_CS0_OFFSET			0x0B38
#define TI816X_CONTROL_PADCONF_GPMC_CS1_OFFSET			0x0B3C
#define TI816X_CONTROL_PADCONF_GPMC_CS2_OFFSET			0x0B40
#define TI816X_CONTROL_PADCONF_GPMC_CS3_OFFSET			0x0B44
#define TI816X_CONTROL_PADCONF_GPMC_CS4_OFFSET			0x0B48
#define TI816X_CONTROL_PADCONF_GPMC_CS5_OFFSET			0x0B4C
#define TI816X_CONTROL_PADCONF_GPMC_WEN_OFFSET			0x0B50
#define TI816X_CONTROL_PADCONF_GPMC_OEN_REN_OFFSET		0x0B54
#define TI816X_CONTROL_PADCONF_GPMC_BE0N_CLE_OFFSET		0x0B58
#define TI816X_CONTROL_PADCONF_GPMC_BE1N_OFFSET			0x0B5C
#define TI816X_CONTROL_PADCONF_GPMC_ADVN_ALE_OFFSET		0x0B60
#define TI816X_CONTROL_PADCONF_GPMC_DIR_OFFSET			0x0B64
#define TI816X_CONTROL_PADCONF_GPMC_WPN_OFFSET			0x0B68
#define TI816X_CONTROL_PADCONF_GPMC_WAIT_OFFSET			0x0B6C
#define TI816X_CONTROL_PADCONF_GPMC_A0_OFFSET			0x0B70
#define TI816X_CONTROL_PADCONF_GPMC_A1_OFFSET			0x0B74
#define TI816X_CONTROL_PADCONF_GPMC_A2_OFFSET			0x0B78
#define TI816X_CONTROL_PADCONF_GPMC_A3_OFFSET			0x0B7C
#define TI816X_CONTROL_PADCONF_GPMC_A4_OFFSET			0x0B80
#define TI816X_CONTROL_PADCONF_GPMC_A5_OFFSET			0x0B84
#define TI816X_CONTROL_PADCONF_GPMC_A6_OFFSET			0x0B88
#define TI816X_CONTROL_PADCONF_GPMC_A7_OFFSET			0x0B8C
#define TI816X_CONTROL_PADCONF_GPMC_A8_OFFSET			0x0B90
#define TI816X_CONTROL_PADCONF_GPMC_A9_OFFSET			0x0B94
#define TI816X_CONTROL_PADCONF_GPMC_A10_OFFSET			0x0B98
#define TI816X_CONTROL_PADCONF_GPMC_A11_OFFSET			0x0B9C
#define TI816X_CONTROL_PADCONF_GPMC_A27_OFFSET			0x0BA0
#define TI816X_CONTROL_PADCONF_GPMC_D0_OFFSET			0x0BA4
#define TI816X_CONTROL_PADCONF_GPMC_D1_OFFSET			0x0BA8
#define TI816X_CONTROL_PADCONF_GPMC_D2_OFFSET			0x0BAC
#define TI816X_CONTROL_PADCONF_GPMC_D3_OFFSET			0x0BB0
#define TI816X_CONTROL_PADCONF_GPMC_D4_OFFSET			0x0BB4
#define TI816X_CONTROL_PADCONF_GPMC_D5_OFFSET			0x0BB8
#define TI816X_CONTROL_PADCONF_GPMC_D6_OFFSET			0x0BBC
#define TI816X_CONTROL_PADCONF_GPMC_D7_OFFSET			0x0BC0
#define TI816X_CONTROL_PADCONF_GPMC_D8_OFFSET			0x0BC4
#define TI816X_CONTROL_PADCONF_GPMC_D9_OFFSET			0x0BC8
#define TI816X_CONTROL_PADCONF_GPMC_D10_OFFSET			0x0BCC
#define TI816X_CONTROL_PADCONF_GPMC_D11_OFFSET			0x0BD0
#define TI816X_CONTROL_PADCONF_GPMC_D12_OFFSET			0x0BD4
#define TI816X_CONTROL_PADCONF_GPMC_D13_OFFSET			0x0BD8
#define TI816X_CONTROL_PADCONF_GPMC_D14_OFFSET			0x0BDC
#define TI816X_CONTROL_PADCONF_GPMC_D15_OFFSET			0x0BE0
#define TI816X_CONTROL_PADCONF_GPMC_CLK_OFFSET			0x0BE4
#define TI816X_CONTROL_PADCONF_GMII0_COL_OFFSET			0x0BE8
#define TI816X_CONTROL_PADCONF_GMII0_CRS_OFFSET			0x0BEC
#define TI816X_CONTROL_PADCONF_GMII0_GTXCLK_OFFSET		0x0BF0
#define TI816X_CONTROL_PADCONF_GMII0_RXCLK_OFFSET		0x0BF4
#define TI816X_CONTROL_PADCONF_GMII0_RXD0_OFFSET		0x0BF8
#define TI816X_CONTROL_PADCONF_GMII0_RXD1_OFFSET		0x0BFC
#define TI816X_CONTROL_PADCONF_GMII0_RXD2_OFFSET		0x0C00
#define TI816X_CONTROL_PADCONF_GMII0_RXD3_OFFSET		0x0C04
#define TI816X_CONTROL_PADCONF_GMII0_RXD4_OFFSET		0x0C08
#define TI816X_CONTROL_PADCONF_GMII0_RXD5_OFFSET		0x0C0C
#define TI816X_CONTROL_PADCONF_GMII0_RXD6_OFFSET		0x0C10
#define TI816X_CONTROL_PADCONF_GMII0_RXD7_OFFSET		0x0C14
#define TI816X_CONTROL_PADCONF_GMII0_RXDV_OFFSET		0x0C18
#define TI816X_CONTROL_PADCONF_GMII0_RXER_OFFSET		0x0C1C
#define TI816X_CONTROL_PADCONF_GMII0_TXCLK_OFFSET		0x0C20
#define TI816X_CONTROL_PADCONF_GMII0_TXD0_OFFSET		0x0C24
#define TI816X_CONTROL_PADCONF_GMII0_TXD1_OFFSET		0x0C28
#define TI816X_CONTROL_PADCONF_GMII0_TXD2_OFFSET		0x0C2C
#define TI816X_CONTROL_PADCONF_GMII0_TXD3_OFFSET		0x0C30
#define TI816X_CONTROL_PADCONF_GMII0_TXD4_OFFSET		0x0C34
#define TI816X_CONTROL_PADCONF_GMII0_TXD5_OFFSET		0x0C38
#define TI816X_CONTROL_PADCONF_GMII0_TXD6_OFFSET		0x0C3C
#define TI816X_CONTROL_PADCONF_GMII0_TXD7_OFFSET		0x0C40
#define TI816X_CONTROL_PADCONF_GMII0_TXEN_OFFSET		0x0C44
#define TI816X_CONTROL_PADCONF_MDIO_MCLK_OFFSET			0x0C48
#define TI816X_CONTROL_PADCONF_MDIO_MDIO_OFFSET			0x0C4C
#define TI816X_CONTROL_PADCONF_VLYNQ_CLOCK_OFFSET		0x0C50
#define TI816X_CONTROL_PADCONF_VLYNQ_SCRUN_OFFSET		0x0C54
#define TI816X_CONTROL_PADCONF_VLYNQ_TXD0_OFFSET		0x0C58
#define TI816X_CONTROL_PADCONF_VLYNQ_TXD1_OFFSET		0x0C5C
#define TI816X_CONTROL_PADCONF_VLYNQ_TXD2_OFFSET		0x0C60
#define TI816X_CONTROL_PADCONF_VLYNQ_TXD3_OFFSET		0x0C64
#define TI816X_CONTROL_PADCONF_VLYNQ_RXD0_OFFSET		0x0C68
#define TI816X_CONTROL_PADCONF_VLYNQ_RXD1_OFFSET		0x0C6C
#define TI816X_CONTROL_PADCONF_VLYNQ_RXD2_OFFSET		0x0C70
#define TI816X_CONTROL_PADCONF_VLYNQ_RXD3_OFFSET		0x0C74
#define TI816X_CONTROL_PADCONF_IIC0_SCL_OFFSET			0x0C78
#define TI816X_CONTROL_PADCONF_IIC0_SDA_OFFSET			0x0C7C
#define TI816X_CONTROL_PADCONF_IIC1_SCL_OFFSET			0x0C80
#define TI816X_CONTROL_PADCONF_IIC1_SDA_OFFSET			0x0C84
#define TI816X_CONTROL_PADCONF_GP0_IO0_OFFSET			0x0C88
#define TI816X_CONTROL_PADCONF_GP0_IO1_OFFSET			0x0C8C
#define TI816X_CONTROL_PADCONF_GP0_IO2_OFFSET			0x0C90
#define TI816X_CONTROL_PADCONF_GP0_IO3_OFFSET			0x0C94
#define TI816X_CONTROL_PADCONF_GP0_IO4_OFFSET			0x0C98
#define TI816X_CONTROL_PADCONF_GP0_IO5_OFFSET			0x0C9C
#define TI816X_CONTROL_PADCONF_GP0_IO6_OFFSET			0x0CA0
#define TI816X_CONTROL_PADCONF_GP0_IO7_OFFSET			0x0CA4
#define TI816X_CONTROL_PADCONF_GP1_IO30_OFFSET			0x0CA8
#define TI816X_CONTROL_PADCONF_GP1_IO31_OFFSET			0x0CAC
#define TI816X_CONTROL_PADCONF_HDMI_SCL_OFFSET			0x0CB0
#define TI816X_CONTROL_PADCONF_HDMI_SDA_OFFSET			0x0CB4
#define TI816X_CONTROL_PADCONF_HDMI_CEC_OFFSET			0x0CB8
#define TI816X_CONTROL_PADCONF_HDMI_HPDET_OFFSET		0x0CBC
#define TI816X_CONTROL_PADCONF_TCLK_OFFSET			0x0CC0
#define TI816X_CONTROL_PADCONF_RTCK_OFFSET			0x0CC4
#define TI816X_CONTROL_PADCONF_TDI_OFFSET			0x0CC8
#define TI816X_CONTROL_PADCONF_TDO_OFFSET			0x0CCC
#define TI816X_CONTROL_PADCONF_TMS_OFFSET			0x0CD0
#define TI816X_CONTROL_PADCONF_TRSTN_OFFSET			0x0CD4
#define TI816X_CONTROL_PADCONF_EMU0_OFFSET			0x0CD8
#define TI816X_CONTROL_PADCONF_EMU1_OFFSET			0x0CDC
#define TI816X_CONTROL_PADCONF_EMU2_OFFSET			0x0CE0
#define TI816X_CONTROL_PADCONF_EMU3_OFFSET			0x0CE4
#define TI816X_CONTROL_PADCONF_EMU4_OFFSET			0x0CE8
#define TI816X_CONTROL_PADCONF_RESETN_OFFSET			0x0CEC
#define TI816X_CONTROL_PADCONF_NMIN_OFFSET			0x0CF0
#define TI816X_CONTROL_PADCONF_RSTOUTN_OFFSET			0x0CF4
#define TI816X_CONTROL_PADCONF_WD_OUT_OFFSET			0x0CF8
#define TI816X_CONTROL_PADCONF_CLKOUT_OFFSET			0x0CFC
#define TI816X_CONTROL_PADCONF_CLKIN32_OFFSET			0x0D00
#define TI816X_CONTROL_PADCONF_USB0_DRVVBUS_OFFSET		0x0D04
#define TI816X_CONTROL_PADCONF_USB1_DRVVBUS_OFFSET		0x0D08

#define TI816X_CONTROL_PADCONF_MUX_SIZE				\
		(TI816X_CONTROL_PADCONF_USB1_DRVVBUS_OFFSET + 0x4)

#endif
