/*
 * TI81XX Mux data. Currently only has TI816X data.
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 *
 * Derived from: arch/arm/mach-omap2/mux34xx.c Original copyright follows:
 *
 * Copyright (C) 2009 Nokia
 * Copyright (C) 2009 Texas Instruments
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/module.h>
#include <linux/init.h>

#include "mux.h"

/* TODO: Check if we need to add ballentry, subset data too */

#ifdef CONFIG_OMAP_MUX

#define _TI816X_MUXENTRY(M0, g, m0, m1, m2, m3, m4, m5, m6, m7)		\
{									\
	.reg_offset	= (TI816X_CONTROL_PADCONF_##M0##_OFFSET),	\
	.gpio		= (g),						\
	.muxnames	= { m0, m1, m2, m3, m4, m5, m6, m7 },		\
}

/*
 * Superset of all mux modes for TI816X
 */
static struct omap_mux __initdata ti816x_muxmodes[] = {
	_TI816X_MUXENTRY(TSI0_DCLK, 0,
		"tsi0_dclk", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI0_DATA, 0,
		"tsi0_data", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI0_BYTSTRT, 0,
		"tsi0_bytstrt", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI0_PACVAL, 0,
		"tsi0_pacval", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI0_PACERR, 0,
		"tsi0_pacerr", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI1_DCLK, 0,
		"tsi1_dclk", "vout1_b_cb_c3", "vin1_d9", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI1_DATA, 0,
		"tsi1_data", "vout1_b_cb_c4", "vin1_d10", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI1_BYTSTRT, 0,
		"tsi1_bytstrt", "vout1_b_cb_c5", "vin1_d11", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI1_PACVAL, 0,
		"tsi1_pacval", "vout1_b_cb_c6", "vin1_d12", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI1_PACERR, 0,
		"tsi1_pacerr", "vout1_b_cb_c7", "vin1_d13", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI2_DCLK, 0,
		"tsi2_dclk", "vin1_d14", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI2_DATA, 0,
		"tsi2_data", "vin0_d20", "vin0_de1", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI2_BYTSTRT, 0,
		"tsi2_bytstrt", "vin0_d21", "vin0_fld1", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI2_PACVAL, 0,
		"tsi2_pacval", "vin0_d22", "vin0_vsync1", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI2_PACERR, 0,
		"tsi2_pacerr", "vin0_d23", "vin0_hsync1", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI3_DCLK, 0,
		"tsi3_dclk", "vout1_g_y_yc6", "vin1_d4", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI3_DATA, 0,
		"tsi3_data", "vout1_g_y_yc7", "vin1_d5", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI3_BYTSTRT, 0,
		"tsi3_bytstrt", "vout1_g_y_yc8", "vin1_d6", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI3_PACVAL, 0,
		"tsi3_pacval", "vout1_g_y_yc9", "vin1_d7", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI3_PACERR, 0,
		"tsi3_pacerr", "vout1_b_cb_c2", "vin1_d8", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI4_DCLK, 0,
		"tsi4_dclk", "vout1_hsync", "vin1_d15", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI4_DATA, 0,
		"tsi4_data", "vin0_d16", "vin1_hsync0", "vout1_fld",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI4_BYTSTRT, 0,
		"tsi4_bytstrt", "vin0_d17", "vin1_vsync0", "vout1_vsync",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI4_PACVAL, 0,
		"tsi4_pacval", "vin0_d18", "vin1_fld0", "vout1_b_cb_c8",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI4_PACERR, 0,
		"tsi4_pacerr", "vin0_d19", "vin1_de0", "vout1_b_cb_c9",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI5_DCLK, 0,
		"tsi5_dclk", "vout0_r_cr0", "vout1_b_cb_c8", "vout1_clk",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI5_DATA, 0,
		"tsi5_data", "vout0_b_cb_c0", "vout1_b_cb_c9", "vin1_hsync1",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI5_BYTSTRT, 0,
		"tsi5_bytstrt", "vout0_b_cb_c1", "vout1_hsync", "vout1_avid",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI5_PACVAL, 0,
		"tsi5_pacval", "vout0_g_y_yc0", "vout1_vsync", "vin1_vsync1",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI5_PACERR, 0,
		"tsi5_pacerr", "vout0_g_y_yc1", "vout1_fld", "vin1_fld1",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI6_DCLK, 0,
		"tsi6_dclk", "vout1_avid", "vin1_clk1", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI6_DATA, 0,
		"tsi6_data", "vin0_hsync0", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI6_BYTSTRT, 0,
		"tsi6_bytstrt", "vin0_vsync0", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI6_PACVAL, 0,
		"tsi6_pacval", "vin0_fld0", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI6_PACERR, 0,
		"tsi6_pacerr", "vin0_de0", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI7_DCLK, 0,
		"tsi7_dclk", "vout0_hsync", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI7_DATA, 0,
		"tsi7_data", "vout0_vsync", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI7_BYTSTRT, 0,
		"tsi7_bytstrt", "vout0_fld", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI7_PACVAL, 0,
		"tsi7_pacval", "vout0_avid", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSI7_PACERR, 0,
		"tsi7_pacerr", "vout0_r_cr1", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSO0_DCLK, 0,
		"tso0_dclk", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSO0_DATA, 0,
		"tso0_data", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSO0_BYTSTRT, 0,
		"tso0_bytstrt", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSO0_PACVAL, 0,
		"tso0_pacval", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSO0_PACERR, 0,
		"tso0_pacerr", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSO1_DCLK, 0,
		"tso1_dclk", "vout1_clk", "vin1_clk0", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSO1_DATA, 0,
		"tso1_data", "vout1_g_y_yc2", "vin1_d0", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSO1_BYTSTRT, 0,
		"tso1_bytstrt", "vout1_g_y_yc3", "vin1_d1", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSO1_PACVAL, 0,
		"tso1_pacval", "vout1_g_y_yc4", "vin1_d2", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TSO1_PACERR, 0,
		"tso1_pacerr", "vout1_g_y_yc5", "vin1_d3", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSI_DCLK, 0,
		"mtsi_dclk", "gmii1_rxclk", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSI_DATA0, 0,
		"mtsi_data0", "gmii1_rxd0", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSI_DATA1, 0,
		"mtsi_data1", "gmii1_rxd1", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSI_DATA2, 0,
		"mtsi_data2", "gmii1_rxd2", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSI_DATA3, 0,
		"mtsi_data3", "gmii1_rxd3", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSI_DATA4, 0,
		"mtsi_data4", "gmii1_rxd4", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSI_DATA5, 0,
		"mtsi_data5", "gmii1_rxd5", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSI_DATA6, 0,
		"mtsi_data6", "gmii1_rxd6", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSI_DATA7, 0,
		"mtsi_data7", "gmii1_rxd7", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSI_BYTSTRT, 0,
		"mtsi_bytstrt", "gmii1_rxdv", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSO_DCLK, 0,
		"mtso_dclk", "gmii1_gtxclk", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSO_DATA0, 0,
		"mtso_data0", "gmii1_txd0", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSO_DATA1, 0,
		"mtso_data1", "gmii1_txd1", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSO_DATA2, 0,
		"mtso_data2", "gmii1_txd2", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSO_DATA3, 0,
		"mtso_data3", "gmii1_txd3", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSO_DATA4, 0,
		"mtso_data4", "gmii1_txd4", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSO_DATA5, 0,
		"mtso_data5", "gmii1_txd5", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSO_DATA6, 0,
		"mtso_data6", "gmii1_txd6", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSO_DATA7, 0,
		"mtso_data7", "gmii1_txd7", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MTSO_BYTSTRT, 0,
		"mtso_bytstrt", "gmii1_txen", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCTL_SCLK, 0,
		"mctl_sclk", "gmii1_txclk", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCTL_SCTL, 0,
		"mctl_sctl", "gmii1_col", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCTL_SDI, 0,
		"mctl_sdi", "gmii1_crs", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCTL_SDO, 0,
		"mctl_sdo", "gmii1_rxer", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCARD_MDET, 0,
		"mcard_mdet", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCARD_CD1, 0,
		"mcard_cd1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCARD_CD2, 0,
		"mcard_cd2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCARD_VS1, 0,
		"mcard_vs1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCARD_VS2, 0,
		"mcard_vs2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCARD_VCCEN, 0,
		"mcard_vccen", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCARD_VPPEN, 0,
		"mcard_vppen", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCARD_RESET, 0,
		"mcard_reset", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_CLK0, 0,
		"vin0_clk0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_CLK1, 0,
		"vin0_clk1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D0, 0,
		"vin0_d0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D1, 0,
		"vin0_d1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D2, 0,
		"vin0_d2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D3, 0,
		"vin0_d3", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D4, 0,
		"vin0_d4", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D5, 0,
		"vin0_d5", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D6, 0,
		"vin0_d6", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D7, 0,
		"vin0_d7", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D8, 0,
		"vin0_d8", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D9, 0,
		"vin0_d9", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D10, 0,
		"vin0_d10", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D11, 0,
		"vin0_d11", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D12, 0,
		"vin0_d12", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D13, 0,
		"vin0_d13", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D14, 0,
		"vin0_d14", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VIN0_D15, 0,
		"vin0_d15", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_CLK, 0,
		"vout0_clk", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_G_Y_YC2, 0,
		"vout0_g_y_yc2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_G_Y_YC3, 0,
		"vout0_g_y_yc3", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_G_Y_YC4, 0,
		"vout0_g_y_yc4", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_G_Y_YC5, 0,
		"vout0_g_y_yc5", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_G_Y_YC6, 0,
		"vout0_g_y_yc6", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_G_Y_YC7, 0,
		"vout0_g_y_yc7", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_G_Y_YC8, 0,
		"vout0_g_y_yc8", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_G_Y_YC9, 0,
		"vout0_g_y_yc9", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_B_CB_C2, 0,
		"vout0_b_cb_c2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_B_CB_C3, 0,
		"vout0_b_cb_c3", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_B_CB_C4, 0,
		"vout0_b_cb_c4", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_B_CB_C5, 0,
		"vout0_b_cb_c5", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_B_CB_C6, 0,
		"vout0_b_cb_c6", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_B_CB_C7, 0,
		"vout0_b_cb_c7", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_B_CB_C8, 0,
		"vout0_b_cb_c8", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_B_CB_C9, 0,
		"vout0_b_cb_c9", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_R_CR2, 0,
		"vout0_r_cr2", "vout0_hsync", "vout1_g_y_yc2", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_R_CR3, 0,
		"vout0_r_cr3", "vout0_vsync", "vout1_g_y_yc3", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_R_CR4, 0,
		"vout0_r_cr4", "vout0_fld", "vout1_g_y_yc4", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_R_CR5, 0,
		"vout0_r_cr5", "vout0_avid", "vout1_g_y_yc5", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_R_CR6, 0,
		"vout0_r_cr6", "vout0_g_y_yc0", "vout1_g_y_yc6", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_R_CR7, 0,
		"vout0_r_cr7", "vout0_g_y_yc1", "vout1_g_y_yc7", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_R_CR8, 0,
		"vout0_r_cr8", "vout0_b_cb_c0", "vout1_g_y_yc8", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VOUT0_R_CR9, 0,
		"vout0_r_cr9", "vout0_b_cb_c1", "vout1_g_y_yc9", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_ACLKR, 0,
		"mca0_aclkr", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_AHCLKR, 0,
		"mca0_ahclkr", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_AFSR, 0,
		"mca0_afsr", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_ACLKX, 0,
		"mca0_aclkx", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_ACLKHX, 0,
		"mca0_aclkhx", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_AFSX, 0,
		"mca0_afsx", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_AMUTE, 0,
		"mca0_amute", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_AXR0, 0,
		"mca0_axr0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_AXR1, 0,
		"mca0_axr1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_AXR2, 0,
		"mca0_axr2", "mcb_fsx", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_AXR3, 0,
		"mca0_axr3", "mcb_fsr", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_AXR4, 0,
		"mca0_axr4", "mcb_dx", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA0_AXR5, 0,
		"mca0_axr5", "mcb_dr", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA1_ACLKR, 0,
		"mca1_aclkr", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA1_AHCLKR, 0,
		"mca1_ahclkr", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA1_AFSR, 0,
		"mca1_afsr", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA1_ACLKX, 0,
		"mca1_aclkx", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA1_ACLKHX, 0,
		"mca1_aclkhx", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA1_AFSX, 0,
		"mca1_afsx", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA1_AMUTE, 0,
		"mca1_amute", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA1_AXR0, 0,
		"mca1_axr0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA1_AXR1, 0,
		"mca1_axr1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA2_ACLKR, 0,
		"mca2_aclkr", "mcb_clkr", "mcb_dr", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA2_AHCLKR, 0,
		"mca2_ahclkr", "mcb_clks", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA2_AFSR, 0,
		"mca2_afsr", "mcb_clkx", "mcb_fsr", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA2_ACLKX, 0,
		"mca2_aclkx", "mcb_clkx", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA2_ACLKHX, 0,
		"mca2_aclkhx", "mcb_clkr", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA2_AFSX, 0,
		"mca2_afsx", "mcb_clks", "mcb_fsx", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA2_AMUTE, 0,
		"mca2_amute", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA2_AXR0, 0,
		"mca2_axr0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MCA2_AXR1, 0,
		"mca2_axr1", "mcb_dx", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MMC_POW, 0,
		"mmc_pow", "gpmc_a14", "gp1_io0", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MMC_CLK, 0,
		"mmc_clk", "gpmc_a13", "gp1_io1", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MMC_CMD, 0,
		"mmc_cmd", "gpmc_a21", "gp1_io2", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MMC_DAT0, 0,
		"mmc_dat0", "gpmc_a20", "gp1_io3", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MMC_DAT1_SDIRQ, 0,
		"mmc_dat1_sdirq", "gpmc_a19", "gp1_io4", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MMC_DAT2_SDRW, 0,
		"mmc_dat2_sdrw", "gpmc_a18", "gp1_io5", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MMC_DAT3, 0,
		"mmc_dat3", "gpmc_a17", "gp1_io6", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MMC_SDCD, 0,
		"mmc_sdcd", "gpmc_a16", "gp1_io7", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MMC_SDWP, 0,
		"mmc_sdwp", "gpmc_a15", "gp1_io8", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SPI_SCLK, 0,
		"spi_sclk", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SPI_SCS0, 0,
		"spi_scs0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SPI_SCS1, 0,
		"spi_scs1", "gpmc_a23", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SPI_SCS2, 0,
		"spi_scs2", "gpmc_a22", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SPI_SCS3, 0,
		"spi_scs3", "gpmc_a21", "gp1_io22", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SPI_D0, 0,
		"spi_d0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SPI_D1, 0,
		"spi_d1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART0_RXD, 0,
		"uart0_rxd", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART0_TXD, 0,
		"uart0_txd", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART0_RTSN, 0,
		"uart0_rtsn", "gp1_io27", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART0_CTSN, 0,
		"uart0_ctsn", "gp1_io28", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART0_DTRN, 0,
		"uart0_dtrn", "gpmc_a20", "gpmc_a12", "gp1_io16",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART0_DSRN, 0,
		"uart0_dsrn", "gpmc_a19", "gpmc_a24", "gp1_io17",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART0_DCDN, 0,
		"uart0_dcdn", "gpmc_a18", "gpmc_a23", "gp1_io18",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART0_RIN, 0,
		"uart0_rin", "gpmc_a17", "gpmc_a22", "gp1_io19",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART1_RXD, 0,
		"uart1_rxd", "gpmc_a26", "gpmc_a20", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART1_TXD, 0,
		"uart1_txd", "gpmc_a25", "gpmc_a19", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART1_RTSN, 0,
		"uart1_rtsn", "gpmc_a14", "gpmc_a18", "gp1_io25",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART1_CTSN, 0,
		"uart1_ctsn", "gpmc_a13", "gpmc_a17", "gp1_io26",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART2_RXD, 0,
		"uart2_rxd", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART2_TXD, 0,
		"uart2_txd", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART2_RTSN, 0,
		"uart2_rtsn", "gpmc_a15", "gpmc_a26", "gp1_io23",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(UART2_CTSN, 0,
		"uart2_ctsn", "gpmc_a16", "gpmc_a25", "gp1_io24",
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC0_DET, 0,
		"sc0_det", "gpmc_a27", "gp1_io9", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC0_RST, 0,
		"sc0_rst", "gpmc_a22", "gp1_io10", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC0_CLK, 0,
		"sc0_clk", "gpmc_a26", "gp1_io11", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC0_DATA, 0,
		"sc0_data", "gpmc_a25", "gp1_io12", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC0_C4, 0,
		"sc0_c4", "gp1_io13", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC0_VCCEN, 0,
		"sc0_vccen", "gpmc_a23", "gp1_io14", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC0_VPPEN, 0,
		"sc0_vppen", "gpmc_a24", "gp1_io15", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC1_DET, 0,
		"sc1_det", "gpmc_a16", "gp0_io21", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC1_RST, 0,
		"sc1_rst", "gpmc_a15", "gp0_io22", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC1_CLK, 0,
		"sc1_clk", "gpmc_a14", "gp0_io23", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC1_DATA, 0,
		"sc1_data", "gpmc_a13", "gp0_io24", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC1_C4, 0,
		"sc1_c4", "gp0_io25", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC1_VCCEN, 0,
		"sc1_vccen", "gpmc_a21", "gp0_io26", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(SC1_VPPEN, 0,
		"sc1_vppen", "gpmc_a12", "gp0_io27", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TIM4_OUT, 0,
		"tim4_out", "gp0_io28", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TIM5_OUT, 0,
		"tim5_out", "gp0_io29", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TIM6_OUT, 0,
		"tim6_out", "gpmc_a24", "gp0_io30", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TIM7_OUT, 0,
		"tim7_out", "gpmc_a12", "gp0_io31", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_CS0, 0,
		"gpmc_cs0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_CS1, 0,
		"gpmc_cs1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_CS2, 0,
		"gpmc_cs2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_CS3, 0,
		"gpmc_cs3", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_CS4, 0,
		"gpmc_cs4", "gp1_io21", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_CS5, 0,
		"gpmc_cs5", "gpmc_a12", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_WEN, 0,
		"gpmc_wen", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_OEN_REN, 0,
		"gpmc_oen_ren", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_BE0N_CLE, 0,
		"gpmc_be0n_cle", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_BE1N, 0,
		"gpmc_be1n", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_ADVN_ALE, 0,
		"gpmc_advn_ale", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_DIR, 0,
		"gpmc_dir", "gp1_io20", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_WPN, 0,
		"gpmc_wpn", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_WAIT, 0,
		"gpmc_wait", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A0, 0,
		"gpmc_a0", "gp0_io8", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A1, 0,
		"gpmc_a1", "gp0_io9", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A2, 0,
		"gpmc_a2", "gp0_io10", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A3, 0,
		"gpmc_a3", "gp0_io11", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A4, 0,
		"gpmc_a4", "gp0_io12", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A5, 0,
		"gpmc_a5", "gp0_io13", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A6, 0,
		"gpmc_a6", "gp0_io14", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A7, 0,
		"gpmc_a7", "gp0_io15", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A8, 0,
		"gpmc_a8", "gp0_io16", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A9, 0,
		"gpmc_a9", "gp0_io17", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A10, 0,
		"gpmc_a10", "gp0_io18", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A11, 0,
		"gpmc_a11", "gp0_io19", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_A27, 0,
		"gpmc_a27", "gp0_io20", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D0, 0,
		"gpmc_d0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D1, 0,
		"gpmc_d1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D2, 0,
		"gpmc_d2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D3, 0,
		"gpmc_d3", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D4, 0,
		"gpmc_d4", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D5, 0,
		"gpmc_d5", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D6, 0,
		"gpmc_d6", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D7, 0,
		"gpmc_d7", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D8, 0,
		"gpmc_d8", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D9, 0,
		"gpmc_d9", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D10, 0,
		"gpmc_d10", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D11, 0,
		"gpmc_d11", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D12, 0,
		"gpmc_d12", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D13, 0,
		"gpmc_d13", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D14, 0,
		"gpmc_d14", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_D15, 0,
		"gpmc_d15", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GPMC_CLK, 0,
		"gpmc_clk", "gp1_io29", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_COL, 0,
		"gmii0_col", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_CRS, 0,
		"gmii0_crs", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_GTXCLK, 0,
		"gmii0_gtxclk", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_RXCLK, 0,
		"gmii0_rxclk", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_RXD0, 0,
		"gmii0_rxd0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_RXD1, 0,
		"gmii0_rxd1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_RXD2, 0,
		"gmii0_rxd2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_RXD3, 0,
		"gmii0_rxd3", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_RXD4, 0,
		"gmii0_rxd4", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_RXD5, 0,
		"gmii0_rxd5", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_RXD6, 0,
		"gmii0_rxd6", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_RXD7, 0,
		"gmii0_rxd7", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_RXDV, 0,
		"gmii0_rxdv", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_RXER, 0,
		"gmii0_rxer", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_TXCLK, 0,
		"gmii0_txclk", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_TXD0, 0,
		"gmii0_txd0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_TXD1, 0,
		"gmii0_txd1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_TXD2, 0,
		"gmii0_txd2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_TXD3, 0,
		"gmii0_txd3", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_TXD4, 0,
		"gmii0_txd4", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_TXD5, 0,
		"gmii0_txd5", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_TXD6, 0,
		"gmii0_txd6", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_TXD7, 0,
		"gmii0_txd7", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GMII0_TXEN, 0,
		"gmii0_txen", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MDIO_MCLK, 0,
		"mdio_mclk", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(MDIO_MDIO, 0,
		"mdio_mdio", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VLYNQ_CLOCK, 0,
		"vlynq_clock", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VLYNQ_SCRUN, 0,
		"vlynq_scrun", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VLYNQ_TXD0, 0,
		"vlynq_txd0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VLYNQ_TXD1, 0,
		"vlynq_txd1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VLYNQ_TXD2, 0,
		"vlynq_txd2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VLYNQ_TXD3, 0,
		"vlynq_txd3", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VLYNQ_RXD0, 0,
		"vlynq_rxd0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VLYNQ_RXD1, 0,
		"vlynq_rxd1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VLYNQ_RXD2, 0,
		"vlynq_rxd2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(VLYNQ_RXD3, 0,
		"vlynq_rxd3", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(IIC0_SCL, 0,
		"iic0_scl", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(IIC0_SDA, 0,
		"iic0_sda", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(IIC1_SCL, 0,
		"iic1_scl", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(IIC1_SDA, 0,
		"iic1_sda", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GP0_IO0, 0,
		"gp0_io0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GP0_IO1, 0,
		"gp0_io1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GP0_IO2, 0,
		"gp0_io2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GP0_IO3, 0,
		"gp0_io3", "tclkin", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GP0_IO4, 0,
		"gp0_io4", "vcx_vic0", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GP0_IO5, 0,
		"gp0_io5", "mca2_amutein", "gpmc_a24", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GP0_IO6, 0,
		"gp0_io6", "mca1_amutein", "gpmc_a23", NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GP0_IO7, 0,
		"gp0_io7", "mca0_amutein", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GP1_IO30, 0,
		"gp1_io30", "sata_act0_led", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(GP1_IO31, 0,
		"gp1_io31", "sata_act1_led", NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(HDMI_SCL, 0,
		"hdmi_scl", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(HDMI_SDA, 0,
		"hdmi_sda", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(HDMI_CEC, 0,
		"hdmi_cec", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(HDMI_HPDET, 0,
		"hdmi_hpdet", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TCLK, 0,
		"tclk", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(RTCK, 0,
		"rtck", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TDI, 0,
		"tdi", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TDO, 0,
		"tdo", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TMS, 0,
		"tms", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(TRSTN, 0,
		"trstn", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(EMU0, 0,
		"emu0", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(EMU1, 0,
		"emu1", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(EMU2, 0,
		"emu2", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(EMU3, 0,
		"emu3", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(EMU4, 0,
		"emu4", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(RESETN, 0,
		"resetn", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(NMIN, 0,
		"nmin", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(RSTOUTN, 0,
		"rstoutn", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(WD_OUT, 0,
		"wd_out", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(CLKOUT, 0,
		"clkout", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(CLKIN32, 0,
		"clkin32", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(USB0_DRVVBUS, 0,
		"usb0_drvvbus", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	_TI816X_MUXENTRY(USB1_DRVVBUS, 0,
		"usb1_drvvbus", NULL, NULL, NULL,
		NULL, NULL, NULL, NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};

int __init ti81xx_mux_init(struct omap_board_mux *board_subset)
{
	return omap_mux_init("core", 0, TI81XX_CONTROL_PADCONF_MUX_PBASE,
			TI816X_CONTROL_PADCONF_MUX_SIZE, ti816x_muxmodes,
			NULL, board_subset, NULL);
}
#else
int __init ti81xx_mux_init(struct omap_board_mux *board_subset)
{
	return 0;
}
#endif
