/*
 * TI81XX CM register bits.
 *
 * Copyright (C) 2010 Texas Instruments, Inc. - http://www.ti.com/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_CM_REGBITS_81XX_H
#define __ARCH_ARM_MACH_OMAP2_CM_REGBITS_81XX_H

#include "cm.h"

#define TI81XX_CLKSEL_0_0_SHIFT				0
#define TI81XX_CLKSEL_0_0_MASK				(1 << 0)

#define TI81XX_CLKSEL_0_1_SHIFT				0
#define TI81XX_CLKSEL_0_1_MASK				(3 << 0)

#define TI81XX_CLKSEL_0_2_SHIFT				0
#define TI81XX_CLKSEL_0_2_MASK				(7 << 0)

/* Modulemode bit */
#define TI81XX_MODULEMODE_SWCTRL			1

/* IDLEST bit */
#define TI81XX_IDLEST_SHIFT				16
#define TI81XX_IDLEST_MASK				(3 << 16)
#define TI81XX_IDLEST_VAL				3

/* Used for clockdomain control */
#define TI81XX_CLKTRCTRL_SHIFT				0
#define TI81XX_CLKTRCTRL_MASK				(3 << 0)

/* Select CLKOUT_MUX source */
#define TI814X_CMDEVICE_SYSCLKOUT_SRC_SHIFT		0
#define TI814X_CMDEVICE_SYSCLKOUT_SRC_MASK		(3 << 0)

#define TI814X_CMDEVICE_SYSCLKOUT_DIV_SHIFT		3
#define TI814X_CMDEVICE_SYSCLKOUT_DIV_MASK		(7 << 3)

#define TI814X_CMDEVICE_SYSCLKOUT_EN_SHIFT		7
#define TI814X_CMDEVICE_SYSCLKOUT_EN_MASK		(1 << 7)

/* Select OSC source */
#define TI814X_OSC_L3_PLL_CLKS_SHIFT			0
#define TI814X_OSC_L3_PLL_CLKS_MASK			(1 << 0)

#define TI814X_OSC_VIDEO0_PLL_CLKS_SHIFT		16
#define TI814X_OSC_VIDEO0_PLL_CLKS_MASK			(1 << 16)

#define TI814X_OSC_VIDEO1_PLL_CLKS_SHIFT		17
#define TI814X_OSC_VIDEO1_PLL_CLKS_MASK			(1 << 17)

#define TI814X_OSC_HDMI_PLL_CLKS_SHIFT			18
#define TI814X_OSC_HDMI_PLL_CLKS_MASK			(1 << 18)

#define TI814X_OSC_AUDIO_PLL_CLKS_SHIFT			24
#define TI814X_OSC_AUDIO_PLL_CLKS_MASK			(1 << 24)

#define TI814X_OSC_DDR_PLL_CLKS_SHIFT			25
#define TI814X_OSC_DDR_PLL_CLKS_MASK			(1 << 25)

#define TI814X_OSC_USB_PLL_CLKS_SHIFT			26
#define TI814X_OSC_USB_PLL_CLKS_MASK			(1 << 26)

#define TI814X_OSC_DSS_PLL_CLKS_SHIFT			27
#define TI814X_OSC_DSS_PLL_CLKS_MASK			(1 << 27)

#define TI814X_OSC_ISS_PLL_CLKS_SHIFT			28
#define TI814X_OSC_ISS_PLL_CLKS_MASK			(1 << 28)

#define TI814X_OSC_IVA_PLL_CLKS_SHIFT			29
#define TI814X_OSC_IVA_PLL_CLKS_MASK			(1 << 29)

#define TI814X_OSC_SGX_PLL_CLKS_SHIFT			30
#define TI814X_OSC_SGX_PLL_CLKS_MASK			(1 << 30)

#define TI814X_OSC_GEM_PLL_CLKS_SHIFT			31
#define TI814X_OSC_GEM_PLL_CLKS_MASK			(1 << 31)

/* Select ARM_CLKSRC */
#define TI814X_ARM_CLKS_SHIFT				0
#define TI814X_ARM_CLKS_MASK				(1 << 0)

/* Select VIDEO_PLL_CLKSRC */
#define TI814X_VIDEO_PLL_CLK2S_SHIFT			0
#define TI814X_VIDEO_PLL_CLK2S_MASK			(1 << 0)

#define TI814X_VIDEO_PLL_OUTMUX_CLKS_SHIFT		8
#define TI814X_VIDEO_PLL_OUTMUX_CLKS_MASK		(3 << 8)

#define TI814X_VIDEO_PLL_TPPSSSTCO_SHIFT		16
#define TI814X_VIDEO_PLL_TPPSSSTCO_MASK			(3 << 16)

#define TI814X_VIDEO_PLL_TPPSSSTSO_MUX_SHIFT		18
#define TI814X_VIDEO_PLL_TPPSSSTSO_MUX_MASK		(3 << 18)

#define TI814X_VIDEO_PLL_HD_VENC_G_SHIFT		24
#define TI814X_VIDEO_PLL_HD_VENC_G_MASK			(1 << 24)

/* Select MLB_ATL_CLKSRC */
#define TI814X_MLB_ATL_MLB_SHIFT			0
#define TI814X_MLB_ATL_MLB_MASK				(1 << 0)

#define TI814X_MLB_ATL_ATL_SHIFT			16
#define TI814X_MLB_ATL_ATL_MASK				(3 << 16)

/* Select McASP345_AUX_CLKSRC */
#define TI814X_MCASP3_AUX_SHIFT				0
#define TI814X_MCASP3_AUX_MASK				(7 << 0)

#define TI814X_MCASP4_AUX_SHIFT				8
#define TI814X_MCASP4_AUX_MASK				(7 << 8)

#define TI814X_MCASP5_AUX_SHIFT				16
#define TI814X_MCASP5_AUX_MASK				(7 << 16)

/* Select MCASP_AHCLK_CLKSRC */
#define TI814X_MCASP0_AHCLKX_SHIFT			0
#define TI814X_MCASP0_AHCLKX_MASK			(7 << 0)

#define TI814X_MCASP0_AHCLKR_SHIFT			3
#define TI814X_MCASP0_AHCLKR_MASK			(7 << 3)

#define TI814X_MCASP1_AHCLKX_SHIFT			6
#define TI814X_MCASP1_AHCLKX_MASK			(7 << 6)

#define TI814X_MCASP1_AHCLKR_SHIFT			9
#define TI814X_MCASP1_AHCLKR_MASK			(7 << 9)

#define TI814X_MCASP2_AHCLKX_SHIFT			16
#define TI814X_MCASP2_AHCLKX_MASK			(7 << 16)

#define TI814X_MCASP3_AHCLKX_SHIFT			19
#define TI814X_MCASP3_AHCLKX_MASK			(7 << 19)

#define TI814X_MCASP4_AHCLKX_SHIFT			22
#define TI814X_MCASP4_AHCLKX_MASK			(7 << 22)

#define TI814X_MCASP5_AHCLKX_SHIFT			25
#define TI814X_MCASP5_AHCLKX_MASK			(7 << 25)

/* Select McBSP_UART_CLKSRC */
#define TI814X_MCBSP_SHIFT				0
#define TI814X_MCBSP_MASK				(7 << 0)

#define TI814X_UART3_SHIFT				3
#define TI814X_UART3_MASK				(3 << 3)

#define TI814X_UART4_SHIFT				5
#define TI814X_UART4_MASK				(3 << 5)

#define TI814X_UART5_SHIFT				7
#define TI814X_UART5_MASK				(3 << 7)

/* Select HDMI_I2S_CLKSRC */
#define TI814X_HDMI_I2S_CLKSRC_SHIFT			0
#define TI814X_HDMI_I2S_CLKSRC_MASK			(7 << 0)

/* GPIO DB CLK EN Bits */
#define TI816X_GPIO_0_DBCLK_SHIFT			8
#define TI816X_GPIO_1_DBCLK_SHIFT			8

/* Select DMTIMER_CLKSRC */
#define TI814X_DMTIMER1_CLKS_SHIFT			3
#define TI814X_DMTIMER1_CLKS_MASK			(7 << 3)

#define TI814X_DMTIMER2_CLKS_SHIFT			6
#define TI814X_DMTIMER2_CLKS_MASK			(7 << 6)

#define TI814X_DMTIMER3_CLKS_SHIFT			9
#define TI814X_DMTIMER3_CLKS_MASK			(7 << 9)

#define TI814X_DMTIMER4_CLKS_SHIFT			16
#define TI814X_DMTIMER4_CLKS_MASK			(7 << 16)

#define TI814X_DMTIMER5_CLKS_SHIFT			19
#define TI814X_DMTIMER5_CLKS_MASK			(7 << 19)

#define TI814X_DMTIMER6_CLKS_SHIFT			22
#define TI814X_DMTIMER6_CLKS_MASK			(7 << 22)

#define TI814X_DMTIMER7_CLKS_SHIFT			25
#define TI814X_DMTIMER7_CLKS_MASK			(7 << 25)

#define TI814X_DMTIMER8_CLKS_SHIFT			0
#define TI814X_DMTIMER8_CLKS_MASK			(7 << 0)

/* Select CLKOUT_MUX source */
#define TI814X_CLKOUT0_MUX_SHIFT			0
#define TI814X_CLKOUT0_MUX_MASK				(0xF << 0)

#define TI814X_CLKOUT1_MUX_SHIFT			16
#define TI814X_CLKOUT1_MUX_MASK				(0xF << 16)

/* Select RMII_REFCLK_SRC */
#define TI814X_RMII_REFCLK_SHIFT			0
#define TI814X_RMII_REFCLK_MASK				(1 << 0)

#define TI814X_CPTS_RFT_SHIFT				1
#define TI814X_CPTS_RFT_MASK				(7 << 1)

/* Select SECSS_CLK_SRC */
#define TI814X_SECSS_CLKS_SHIFT				0
#define TI814X_SECSS_CLKS_MASK				(1 << 0)

/* Select SYSCLK18_CLKSRC */
#define TI814X_SYSCLK18_SHIFT				0
#define TI814X_SYSCLK18_MASK				(1 << 0)

/* Select WDT0_CLKSRC */
#define TI814X_WDT0_SHIFT				0
#define TI814X_WDT0_MASK				(1 << 0)

/* Select EMIF_CLK_GATE */
#define TI814X_EMIFSS_CLK_GATE_SHIFT			0
#define TI814X_EMIFSS_CLK_GATE_ENABLE			(0 << 1)
#define TI814X_EMIFSS_CLK_GATE_DISABLE			(1 << 1)

#define TI814X_DDRPHY1_CLK_GATE_SHIFT			1
#define TI814X_DDRPHY1_CLK_GATE_ENABLE			(0 << 1)
#define TI814X_DDRPHY1_CLK_GATE_DISABLE			(1 << 1)

/* Select DMTIMER_CLK_CHANGE */
#define TI814X_DMTIMER8_IDLEREQ_SHIFT			0
#define TI814X_DMTIMER8_IDLEREQ_MASK			(1 << 0)

#define TI814X_DMTIMER1_IDLEREQ_SHIFT			1
#define TI814X_DMTIMER1_IDLEREQ_MASK			(1 << 1)

#define TI814X_DMTIMER2_IDLEREQ_SHIFT			2
#define TI814X_DMTIMER2_IDLEREQ_MASK			(1 << 2)

#define TI814X_DMTIMER3_IDLEREQ_SHIFT			3
#define TI814X_DMTIMER3_IDLEREQ_MASK			(1 << 3)

#define TI814X_DMTIMER4_IDLEREQ_SHIFT			4
#define TI814X_DMTIMER4_IDLEREQ_MASK			(1 << 4)

#define TI814X_DMTIMER5_IDLEREQ_SHIFT			5
#define TI814X_DMTIMER5_IDLEREQ_MASK			(1 << 5)

#define TI814X_DMTIMER6_IDLEREQ_SHIFT			6
#define TI814X_DMTIMER6_IDLEREQ_MASK			(1 << 6)

#define TI814X_DMTIMER7_IDLEREQ_SHIFT			7
#define TI814X_DMTIMER7_IDLEREQ_MASK			(1 << 7)

#define TI814X_DMTIMER8_IDLESTATUS_SHIFT		8
#define TI814X_DMTIMER8_IDLESTATUS_MASK			(1 << 8)

#define TI814X_DMTIMER1_IDLESTATUS_SHIFT		9
#define TI814X_DMTIMER1_IDLESTATUS_MASK			(1 << 9)

#define TI814X_DMTIMER2_IDLESTATUS_SHIFT		10
#define TI814X_DMTIMER2_IDLESTATUS_MASK			(1 << 10)

#define TI814X_DMTIMER3_IDLESTATUS_SHIFT		11
#define TI814X_DMTIMER3_IDLESTATUS_MASK			(1 << 11)

#define TI814X_DMTIMER4_IDLESTATUS_SHIFT		12
#define TI814X_DMTIMER4_IDLESTATUS_MASK			(1 << 12)

#define TI814X_DMTIMER5_IDLESTATUS_SHIFT		13
#define TI814X_DMTIMER5_IDLESTATUS_MASK			(1 << 13)

#define TI814X_DMTIMER6_IDLESTATUS_SHIFT		14
#define TI814X_DMTIMER6_IDLESTATUS_MASK			(1 << 14)

#define TI814X_DMTIMER7_IDLESTATUS_SHIFT		15
#define TI814X_DMTIMER7_IDLESTATUS_MASK			(1 << 15)

/* Select DEEPSLEEP_CTRL */
#define TI814X_DEEPSLEEP_CTRL_DSCOUNT_SHIFT		0
#define TI814X_DEEPSLEEP_CTRL_DSCOUNT_MASK		(0xFFFF << 0)

#define TI814X_DEEPSLEEP_CTRL_DSPOLARITY_SHIFT		16
#define TI814X_DEEPSLEEP_CTRL_DSPOLARITY_MASK		(1 << 16)

#define TI814X_DEEPSLEEP_CTRL_DSENABLE_SHIFT		17
#define TI814X_DEEPSLEEP_CTRL_DSENABLE_MASK		(1 << 17)

/* Select DEEPSLEEP_STATUS */
#define TI814X_DEEPSLEEP_STATUS_DSCOMPLETE_SHIFT	0
#define TI814X_DEEPSLEEP_STATUS_DSCOMPLETE_MASK		(1 << 0)

#endif
