/*
 * linux/arch/arm/mach-omap2/board-saumodule-am3517.c
 *
 * Copyright (C) 2009 Texas Instruments Incorporated
 * Author: Ranjith Lohithakshan <ranjithl@ti.com>
 *
 * Based on mach-omap2/board-am3517evm.c
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as  published by the
 * Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any kind,
 * whether express or implied; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/clk.h>
#include <linux/platform_device.h>
#include <linux/gpio.h>
#include <linux/can/platform/ti_hecc.h>
#include <linux/davinci_emac.h>
#include <linux/irq.h>
#include <linux/input.h>
#include <linux/mmc/host.h>
#include <linux/mtd/physmap.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/partitions.h>
#include <linux/mtd/nand.h>
#include <linux/jiffies.h>
#include <linux/timer.h>
#include <linux/reboot.h>
#include <linux/workqueue.h>

#include <mach/hardware.h>
#include <mach/am35xx.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>

#include <plat/board.h>
#include <plat/common.h>
#include <plat/usb.h>
#include <plat/display.h>
#include <plat/gpmc.h>
#include <plat/nand.h>

#include <media/davinci/vpfe_capture.h>

#include "mux.h"
#include "control.h"
#include "hsmmc.h"
#include "board-flash.h"
#include "clock.h"

#include <linux/tca8418_keypad.h>
#include <linux/i2c/at24.h>

#include <linux/regulator/machine.h>
#include <linux/mfd/tps6507x.h>
#include <linux/regulator/tps6507x.h>
#include <linux/regulator/fixed.h>
#include <linux/input/tps6507x-ts.h>

#include <linux/leds.h>

#define AM35XX_EVM_MDIO_FREQUENCY	(1000000)

#define GPMC_CS0_BASE  0x60
#define GPMC_CS_SIZE   0x30

#define NAND_BLOCK_SIZE        SZ_128K

#define	GPIO_DS1374_IRQ		24
#define GPIO_TCA8418_IRQ	26
#define GPIO_PMIC_IRQ 0

#define GPIO_VBEN_USB1 29

#define GPIO_WL_PDN  136
#define GPIO_WL_NRST 137
#define GPIO_WL_WUP1 138
#define GPIO_WL_WUP2 139

#define GPIO_BT_DTR 126
#define GPIO_BT_DSR 127
#define GPIO_ACC_INT 126 /* new 1.2 board */

#define GPIO_USRLED 28

#define SERIALIZER_SHDN 128
#define DESERIALIZER_SHDN 154
#define SERIALIZER_CKSEL 3

#define GPIO_PMIC_POWERON 27
#define GPIO_PMIC_PBOUT 177

#define GPIO_FAKE_MMC1_CD 2

#define GPIO_KIT_LED 152

#define GPIO_GPSCTL 6

#define GPIO_MAG_IRQ 176

static struct mtd_partition sau3517_nand_partitions[] = {
/* All the partition sizes are listed in terms of NAND block size */
	{
		.name           = "xloader-nand",
		.offset         = 0,
		.size           = 4*(SZ_128K),
		.mask_flags     = MTD_WRITEABLE
	},
	{
		.name           = "uboot-nand",
		.offset         = MTDPART_OFS_APPEND,
		.size           = 14*(SZ_128K),
		.mask_flags     = MTD_WRITEABLE
	},
	{
		.name           = "params-nand",
		.offset         = MTDPART_OFS_APPEND,
		.size           = 2*(SZ_128K)
	},
	{
		.name           = "linux-nand",
		.offset         = MTDPART_OFS_APPEND,
		.size           = 40*(SZ_128K)
	},
	{
		.name           = "jffs2-nand",
		.size           = MTDPART_SIZ_FULL,
		.offset         = MTDPART_OFS_APPEND,
	},
};

static struct mdio_platform_data sau3517_mdio_pdata = {
	.bus_freq	= AM35XX_EVM_MDIO_FREQUENCY,
};

static struct resource am3517_mdio_resources[] = {
	{
		.start  = AM35XX_IPSS_EMAC_BASE + AM35XX_EMAC_MDIO_OFFSET,
		.end    = AM35XX_IPSS_EMAC_BASE + AM35XX_EMAC_MDIO_OFFSET +
			  SZ_4K - 1,
		.flags  = IORESOURCE_MEM,
	},
};

static struct platform_device am3517_mdio_device = {
	.name		= "davinci_mdio",
	.id		= -1,
	.num_resources	= ARRAY_SIZE(am3517_mdio_resources),
	.resource	= am3517_mdio_resources,
	.dev.platform_data = &sau3517_mdio_pdata,
};

static struct emac_platform_data sau3517_emac_pdata = {
	.rmii_en	= 1,
};

static struct resource am3517_emac_resources[] = {
	{
		.start  = AM35XX_IPSS_EMAC_BASE,
		.end    = AM35XX_IPSS_EMAC_BASE + 0x2FFFF,
		.flags  = IORESOURCE_MEM,
	},
	{
		.start  = INT_35XX_EMAC_C0_RXTHRESH_IRQ,
		.end    = INT_35XX_EMAC_C0_RXTHRESH_IRQ,
		.flags  = IORESOURCE_IRQ,
	},
	{
		.start  = INT_35XX_EMAC_C0_RX_PULSE_IRQ,
		.end    = INT_35XX_EMAC_C0_RX_PULSE_IRQ,
		.flags  = IORESOURCE_IRQ,
	},
	{
		.start  = INT_35XX_EMAC_C0_TX_PULSE_IRQ,
		.end    = INT_35XX_EMAC_C0_TX_PULSE_IRQ,
		.flags  = IORESOURCE_IRQ,
	},
	{
		.start  = INT_35XX_EMAC_C0_MISC_PULSE_IRQ,
		.end    = INT_35XX_EMAC_C0_MISC_PULSE_IRQ,
		.flags  = IORESOURCE_IRQ,
	},
};

static struct platform_device am3517_emac_device = {
	.name		= "davinci_emac",
	.id		= -1,
	.num_resources	= ARRAY_SIZE(am3517_emac_resources),
	.resource	= am3517_emac_resources,
};

static void am3517_enable_ethernet_int(void)
{
	u32 regval;

	regval = omap_ctrl_readl(AM35XX_CONTROL_LVL_INTR_CLEAR);
	regval = (regval | AM35XX_CPGMAC_C0_RX_PULSE_CLR |
		AM35XX_CPGMAC_C0_TX_PULSE_CLR |
		AM35XX_CPGMAC_C0_MISC_PULSE_CLR |
		AM35XX_CPGMAC_C0_RX_THRESH_CLR);
	omap_ctrl_writel(regval, AM35XX_CONTROL_LVL_INTR_CLEAR);
	regval = omap_ctrl_readl(AM35XX_CONTROL_LVL_INTR_CLEAR);
}

static void am3517_disable_ethernet_int(void)
{
	u32 regval;

	regval = omap_ctrl_readl(AM35XX_CONTROL_LVL_INTR_CLEAR);
	regval = (regval | AM35XX_CPGMAC_C0_RX_PULSE_CLR |
		AM35XX_CPGMAC_C0_TX_PULSE_CLR);
	omap_ctrl_writel(regval, AM35XX_CONTROL_LVL_INTR_CLEAR);
	regval = omap_ctrl_readl(AM35XX_CONTROL_LVL_INTR_CLEAR);
}

static void sau3517_ethernet_init(struct emac_platform_data *pdata)
{
	u32 regval, mac_lo, mac_hi;

	mac_lo = omap_ctrl_readl(AM35XX_CONTROL_FUSE_EMAC_LSB);
	mac_hi = omap_ctrl_readl(AM35XX_CONTROL_FUSE_EMAC_MSB);

	pdata->mac_addr[0] = (u_int8_t)((mac_hi & 0xFF0000) >> 16);
	pdata->mac_addr[1] = (u_int8_t)((mac_hi & 0xFF00) >> 8);
	pdata->mac_addr[2] = (u_int8_t)((mac_hi & 0xFF) >> 0);
	pdata->mac_addr[3] = (u_int8_t)((mac_lo & 0xFF0000) >> 16);
	pdata->mac_addr[4] = (u_int8_t)((mac_lo & 0xFF00) >> 8);
	pdata->mac_addr[5] = (u_int8_t)((mac_lo & 0xFF) >> 0);

	pdata->ctrl_reg_offset		= AM35XX_EMAC_CNTRL_OFFSET;
	pdata->ctrl_mod_reg_offset	= AM35XX_EMAC_CNTRL_MOD_OFFSET;
	pdata->ctrl_ram_offset		= AM35XX_EMAC_CNTRL_RAM_OFFSET;
	pdata->ctrl_ram_size		= AM35XX_EMAC_CNTRL_RAM_SIZE;
	pdata->version			= EMAC_VERSION_2;
	pdata->hw_ram_addr		= AM35XX_EMAC_HW_RAM_ADDR;
	pdata->interrupt_enable		= am3517_enable_ethernet_int;
	pdata->interrupt_disable	= am3517_disable_ethernet_int;
	am3517_emac_device.dev.platform_data	= pdata;
	platform_device_register(&am3517_mdio_device);
	platform_device_register(&am3517_emac_device);
	clk_add_alias(NULL, dev_name(&am3517_mdio_device.dev),
		      NULL, &am3517_emac_device.dev);

	regval = omap_ctrl_readl(AM35XX_CONTROL_IP_SW_RESET);
	regval = regval & (~(AM35XX_CPGMACSS_SW_RST));
	omap_ctrl_writel(regval, AM35XX_CONTROL_IP_SW_RESET);
	regval = omap_ctrl_readl(AM35XX_CONTROL_IP_SW_RESET);

	return ;
}

static void sau3517_clear_vpfe_intr(int vdint)
{
	unsigned int vpfe_int_clr;

	vpfe_int_clr = omap_ctrl_readl(AM35XX_CONTROL_LVL_INTR_CLEAR);

	switch (vdint) {
	/* VD0 interrrupt */
	case INT_35XX_CCDC_VD0_IRQ:
		vpfe_int_clr &= ~AM35XX_VPFE_CCDC_VD0_INT_CLR;
		vpfe_int_clr |= AM35XX_VPFE_CCDC_VD0_INT_CLR;
		break;
	/* VD1 interrrupt */
	case INT_35XX_CCDC_VD1_IRQ:
		vpfe_int_clr &= ~AM35XX_VPFE_CCDC_VD1_INT_CLR;
		vpfe_int_clr |= AM35XX_VPFE_CCDC_VD1_INT_CLR;
		break;
	/* VD2 interrrupt */
	case INT_35XX_CCDC_VD2_IRQ:
		vpfe_int_clr &= ~AM35XX_VPFE_CCDC_VD2_INT_CLR;
		vpfe_int_clr |= AM35XX_VPFE_CCDC_VD2_INT_CLR;
		break;
	/* Clear all interrrupts */
	default:
		vpfe_int_clr &= ~(AM35XX_VPFE_CCDC_VD0_INT_CLR |
				AM35XX_VPFE_CCDC_VD1_INT_CLR |
				AM35XX_VPFE_CCDC_VD2_INT_CLR);
		vpfe_int_clr |= (AM35XX_VPFE_CCDC_VD0_INT_CLR |
				AM35XX_VPFE_CCDC_VD1_INT_CLR |
				AM35XX_VPFE_CCDC_VD2_INT_CLR);
		break;
	}
	omap_ctrl_writel(vpfe_int_clr, AM35XX_CONTROL_LVL_INTR_CLEAR);
	vpfe_int_clr = omap_ctrl_readl(AM35XX_CONTROL_LVL_INTR_CLEAR);
}

static struct vpfe_config vpfe_cfg = {
	.num_subdevs	= 0,
	.i2c_adapter_id	= 1,
	.sub_devs	= NULL,
	.clr_intr	= sau3517_clear_vpfe_intr,
	.card_name	= "DM6446 EVM",
	.ccdc		= "DM6446 CCDC",
};

static struct resource vpfe_resources[] = {
	{
		.start	= INT_35XX_CCDC_VD0_IRQ,
		.end	= INT_35XX_CCDC_VD0_IRQ,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= INT_35XX_CCDC_VD1_IRQ,
		.end	= INT_35XX_CCDC_VD1_IRQ,
		.flags	= IORESOURCE_IRQ,
	},
};

static u64 vpfe_capture_dma_mask = DMA_BIT_MASK(32);
static struct platform_device vpfe_capture_dev = {
	.name		= CAPTURE_DRV_NAME,
	.id		= -1,
	.num_resources	= ARRAY_SIZE(vpfe_resources),
	.resource	= vpfe_resources,
	.dev = {
		.dma_mask		= &vpfe_capture_dma_mask,
		.coherent_dma_mask	= DMA_BIT_MASK(32),
		.platform_data		= &vpfe_cfg,
	},
};

static struct resource dm644x_ccdc_resource[] = {
	/* CCDC Base address */
	{
		.start	= AM35XX_IPSS_VPFE_BASE,
		.end	= AM35XX_IPSS_VPFE_BASE + 0xffff,
		.flags	= IORESOURCE_MEM,
	},
};

static struct platform_device dm644x_ccdc_dev = {
	.name		= "dm644x_ccdc",
	.id		= -1,
	.num_resources	= ARRAY_SIZE(dm644x_ccdc_resource),
	.resource	= dm644x_ccdc_resource,
	.dev = {
		.dma_mask		= &vpfe_capture_dma_mask,
		.coherent_dma_mask	= DMA_BIT_MASK(32),
	},
};

/* TPS650732 specific initialization */
/* DCDC1 */
static struct regulator_consumer_supply sau3517_vdcdc1_supplies[] = {
	{
		.supply = "vdds",
	},
};

/* DCDC2 */
static struct regulator_consumer_supply sau3517_vdcdc2_supplies[] = {
	{
		.supply = "vddshv",
	},
	REGULATOR_SUPPLY("IOVDD", "1-0018"),
	REGULATOR_SUPPLY("DVDD", "1-0018"),
	REGULATOR_SUPPLY("vdds_sdi", "omapdss"),
	REGULATOR_SUPPLY("vdds_dsi", "omapdss"),
	REGULATOR_SUPPLY("vmmc","mmci-omap-hs.2"),
};

/* DCDC3 */
static struct regulator_consumer_supply sau3517_vdcdc3_supplies[] = {
	{
		.supply = "core",
	},
	{
		.supply = "mpu",
	},
};

/* LDO1 */
static struct regulator_consumer_supply sau3517_ldo1_supplies[] = {
	{
		.supply = "vdda1p8v_usbphy",
	},
	REGULATOR_SUPPLY("vdda_dac", "omapdss"),
};

/* LDO2 */
static struct regulator_consumer_supply sau3517_ldo2_supplies[] = {
	{
		.supply = "vdds_dpll_per_core",
	},
	{
		.supply = "vdds_dpll_mpu_usbhost",
	},
};

static struct regulator_init_data sau3517_regulator_data[] = {
	/* DCDC1 */
	{
		.constraints = {
			.min_uV = 1700000,
			.max_uV = 1950000,
			.valid_modes_mask = REGULATOR_MODE_NORMAL,
			.valid_ops_mask = REGULATOR_CHANGE_VOLTAGE|REGULATOR_CHANGE_STATUS,
			.always_on = true,
			.apply_uV = false,
		},
		.num_consumer_supplies = ARRAY_SIZE(sau3517_vdcdc1_supplies),
		.consumer_supplies = sau3517_vdcdc1_supplies,
	},
	/* DCDC2 */
	{
		.constraints = {
			.min_uV = 1800000,
			.max_uV = 1800000,
			.valid_modes_mask = REGULATOR_MODE_NORMAL,
			.valid_ops_mask = REGULATOR_CHANGE_STATUS,
			.always_on = true,
			.apply_uV = false,
		},
		.num_consumer_supplies = ARRAY_SIZE(sau3517_vdcdc2_supplies),
		.consumer_supplies = sau3517_vdcdc2_supplies,
	},
	/* DCDC3 */
	{
		.constraints = {
			.min_uV = 1140000,
			.max_uV = 1320000,
			.valid_modes_mask = REGULATOR_MODE_NORMAL,
			.valid_ops_mask = REGULATOR_CHANGE_VOLTAGE|REGULATOR_CHANGE_STATUS,
			.always_on = true,
			.apply_uV = false,
		},
		.num_consumer_supplies = ARRAY_SIZE(sau3517_vdcdc3_supplies),
		.consumer_supplies = sau3517_vdcdc3_supplies,
	},
	/* LDO1 */
	{
		.constraints = {
			.min_uV = 1800000,
			.max_uV = 1800000,
			.valid_modes_mask = REGULATOR_MODE_NORMAL,
			.valid_ops_mask = REGULATOR_CHANGE_STATUS,
			.always_on = true,
			.apply_uV = false,
		},
		.num_consumer_supplies = ARRAY_SIZE(sau3517_ldo1_supplies),
		.consumer_supplies = sau3517_ldo1_supplies,
	},
	/* LDO2 */
	{
		.constraints = {
			.min_uV = 1800000,
			.max_uV = 1800000,
			.valid_modes_mask = REGULATOR_MODE_NORMAL,
			.valid_ops_mask = REGULATOR_CHANGE_STATUS,
			.always_on = true,
			.apply_uV = false,
		},
		.num_consumer_supplies = ARRAY_SIZE(sau3517_ldo2_supplies),
		.consumer_supplies = sau3517_ldo2_supplies,
	},
};

static struct touchscreen_init_data tps6507x_touchscreen_data = {
	.poll_period =  30,	/* ms between touch samples */
	.min_pressure = 0x30,	/* minimum pressure to trigger touch */
	.vref = 0,		/* turn off vref when not using A/D */
	.vendor = 0,		/* /sys/class/input/input?/id/vendor */
	.product = 65070,	/* /sys/class/input/input?/id/product */
	.version = 0x100,	/* /sys/class/input/input?/id/version */
};

static void sau3517_poweroff(void);
static void sau3517_initiate_shutdown(void);

static struct tps6507x_board tps_board = {
	.tps6507x_pmic_init_data = &sau3517_regulator_data[0],
	.tps6507x_ts_init_data = &tps6507x_touchscreen_data,
	.switch_off = sau3517_poweroff,
	.shutdown = sau3517_initiate_shutdown,
	.pbtn_gpio = GPIO_PMIC_PBOUT,
};

static struct regulator_consumer_supply ldo_da3_consumers[] = {
	REGULATOR_SUPPLY("AVDD", "1-0018"),
	REGULATOR_SUPPLY("DRVDD", "1-0018"),
};

/* Fixed regulator for tlv320aic3105 */
static struct regulator_init_data ldo_da3 = {
	.constraints =	{
		.name			= "LDO-DA3",
		.min_uV			= 3000000,
		.max_uV			= 3000000,
		.apply_uV		= 1,
		.valid_modes_mask = REGULATOR_MODE_NORMAL,
		.valid_ops_mask = REGULATOR_CHANGE_STATUS,
		.always_on = true,
	},
	.num_consumer_supplies		= ARRAY_SIZE(ldo_da3_consumers),
	.consumer_supplies		= ldo_da3_consumers,
};

static struct fixed_voltage_config ldo_da3_config = {
	.supply_name		= "codec_avdd",
	.microvolts		= 3000000,
	.gpio			= -EINVAL,
	.startup_delay		= 150,
	.init_data		= &ldo_da3,
};

static struct platform_device ldo_da3_dev = {
	.name			= "reg-fixed-voltage",
	.id			= 0,
	.dev			= {
		.platform_data	= &ldo_da3_config,
	},
};

static struct regulator_consumer_supply dcdc_da8_consumers[] = {
	REGULATOR_SUPPLY("VDDA3P3V", NULL),
	REGULATOR_SUPPLY("hsusb0", NULL),
};

/* Fixed regulator for tlv320aic3105 */
static struct regulator_init_data dcdc_da8 = {
	.constraints =	{
		.name			= "DCDC-DA8",
		.min_uV			= 3300000,
		.max_uV			= 3300000,
		.apply_uV		= 1,
		.valid_modes_mask = REGULATOR_MODE_NORMAL,
		.valid_ops_mask = REGULATOR_CHANGE_STATUS,
		.always_on = true,
	},
	.num_consumer_supplies		= ARRAY_SIZE(dcdc_da8_consumers),
	.consumer_supplies		= dcdc_da8_consumers,
};

static struct fixed_voltage_config dcdc_da8_config = {
	.supply_name		= "board-3P3V",
	.microvolts		= 3300000,
	.gpio			= -EINVAL,
	.startup_delay		= 150,
	.init_data		= &dcdc_da8,
};

static struct platform_device dcdc_da8_dev = {
	.name			= "reg-fixed-voltage",
	.id			= 1,
	.dev			= {
		.platform_data	= &dcdc_da8_config,
	},
};

static struct tca8418_keys_platform_data sau3517_tca8418_keys_info = {
	.recode		= NULL, // no recode, use scan codes as key codes
	.only_recoded	= 0,
	.rep 		= 0,
};


static struct i2c_board_info __initdata sau3517_i2c1_boardinfo[] = {
	{
		I2C_BOARD_INFO("ds1374", 0x68),
	},
	{
		I2C_BOARD_INFO("24c512", 0x50),
	},
	{
		I2C_BOARD_INFO("tps6507x", 0x48),
		.flags = I2C_CLIENT_WAKE,
		.platform_data = &tps_board,
	},
	{
		I2C_BOARD_INFO("tlv320aic3x", 0x18),
	},
	{
		I2C_BOARD_INFO("tca8418-keys", 0x34),
		.platform_data = &sau3517_tca8418_keys_info,
	},
#ifdef CONFIG_INPUT_BMA250
	{
		I2C_BOARD_INFO("bma250",0x19),
	},
#endif
#ifdef CONFIG_INPUT_BMP180
	{
		I2C_BOARD_INFO("bmp180",0x77),
	},
#endif
#ifdef CONFIG_SENSORS_HMC5843
	{
		I2C_BOARD_INFO("hmc5883l",0x1E),
	},
#endif
};

static int __init sau3517_i2c_init(void)
{

	omap_register_i2c_bus(1, 400, NULL, 0);
	omap_register_i2c_bus(2, 400, NULL, 0);
	omap_register_i2c_bus(3, 400, NULL, 0);

	return 0;
}

static struct omap_board_config_kernel sau3517_config[] __initdata = {
};

static void __init sau3517_init_irq(void)
{
	omap_board_config = sau3517_config;
	omap_board_config_size = ARRAY_SIZE(sau3517_config);
	omap2_init_common_infrastructure();
	omap2_init_common_devices(NULL, NULL);
	omap_init_irq();
	gpmc_init();
}



static int lcd_enabled;


static void __init sau3517_display_init(void)
{
		
	int r;

	/*
	 * Enable GPIO 3 = SERIALIZER CKSEL
	 */
	r = gpio_request(SERIALIZER_CKSEL, "serializer_cksel");
	if (r) {
		printk(KERN_ERR "failed to get serializer_cksel\n");
		return;
	}
	gpio_direction_output(SERIALIZER_CKSEL,0);
	gpio_set_value(SERIALIZER_CKSEL, 0);

	/*
	 * Enable GPIO 128 = SERIALIZER SHDN
	 */
	r = gpio_request(SERIALIZER_SHDN, "serializer_shdn");
	if (r) {
		printk(KERN_ERR "failed to get serializer_shdn\n");
		return;
	}
	gpio_direction_output(SERIALIZER_SHDN,0);

	/*
	 * Enable GPIO 154 = DESERIALIZER SHDN
	 */
	r = gpio_request(DESERIALIZER_SHDN, "deserializer_shdn");
	if (r) {
		printk(KERN_ERR "failed to get deserializer_shdn\n");
		return;
	}
	gpio_direction_output(DESERIALIZER_SHDN,0);

	printk(KERN_INFO "Display initialized successfully\n");
	return;

}


static int sau3517_panel_enable_lcd(struct omap_dss_device *dssdev)
{
	gpio_set_value(SERIALIZER_CKSEL, 0);
	gpio_set_value(SERIALIZER_SHDN, 1);
	gpio_set_value(DESERIALIZER_SHDN, 1);
	
	lcd_enabled = 1;

	printk(KERN_INFO "LCD Enabled\n");

	return 0;
}

static void sau3517_panel_disable_lcd(struct omap_dss_device *dssdev)
{

	gpio_set_value(SERIALIZER_CKSEL, 0);
	gpio_set_value(SERIALIZER_SHDN, 0);
	gpio_set_value(DESERIALIZER_SHDN, 0);

	lcd_enabled = 0;
}

static struct omap_dss_device sau3517_lcd_device = {
	.type			= OMAP_DISPLAY_TYPE_DPI,
	.name			= "lcd",
	.driver_name		= "techtoys_430_panel",
	.phy.dpi.data_lines 	= 24,
	.platform_enable	= sau3517_panel_enable_lcd,
	.platform_disable	= sau3517_panel_disable_lcd,
};

static int sau3517_panel_enable_tv(struct omap_dss_device *dssdev)
{

	printk(KERN_INFO "TV Enabled\n");

	return 0;
}

static void sau3517_panel_disable_tv(struct omap_dss_device *dssdev)
{
}

static struct omap_dss_device sau3517_tv_device = {
	.type 			= OMAP_DISPLAY_TYPE_VENC,
	.name 			= "tv",
	.driver_name		= "venc",
	.phy.venc.type		= OMAP_DSS_VENC_TYPE_COMPOSITE,
	.platform_enable	= sau3517_panel_enable_tv,
	.platform_disable	= sau3517_panel_disable_tv,
};

static struct omap_dss_device *sau3517_dss_devices[] = {
	&sau3517_lcd_device,
	&sau3517_tv_device,
};

static struct omap_dss_board_info sau3517_dss_data = {
	.num_devices	= ARRAY_SIZE(sau3517_dss_devices),
	.devices	= sau3517_dss_devices,
	.default_device	= &sau3517_lcd_device,
};

static struct platform_device sau3517_dss_device = {
	.name		= "omapdss",
	.id		= -1,
	.dev		= {
		.platform_data	= &sau3517_dss_data,
	},
};

static struct omap_musb_board_data musb_board_data = {
	.interface_type         = MUSB_INTERFACE_ULPI,
	.mode                   = MUSB_HOST,
	.power                  = 500,
};

static __init void sau3517_musb_init(void)
{
	u32 devconf2;

	/*
	 * Set up USB clock/mode in the DEVCONF2 register.
	 */
	devconf2 = omap_ctrl_readl(AM35XX_CONTROL_DEVCONF2);

	/* USB2.0 PHY reference clock is 13 MHz */
	devconf2 &= ~(CONF2_REFFREQ | CONF2_OTGMODE | CONF2_PHY_GPIOMODE);
	devconf2 |=  CONF2_REFFREQ_13MHZ | CONF2_SESENDEN | CONF2_VBDTCTEN
			| CONF2_DATPOL;

	omap_ctrl_writel(devconf2, AM35XX_CONTROL_DEVCONF2);

	usb_musb_init(&musb_board_data);
}

static const struct ehci_hcd_omap_platform_data ehci_pdata __initconst = {
	.port_mode[0] = EHCI_HCD_OMAP_MODE_PHY,
	.port_mode[1] = EHCI_HCD_OMAP_MODE_UNKNOWN,
	.port_mode[2] = EHCI_HCD_OMAP_MODE_UNKNOWN,

	.phy_reset  = true,
	.reset_gpio_port[0]  = 8,
	.reset_gpio_port[1]  = -EINVAL,
	.reset_gpio_port[2]  = -EINVAL
};

#ifdef CONFIG_OMAP_MUX
static struct omap_board_mux board_mux[] __initdata = {

	OMAP3_MUX(GPMC_A10, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_A9, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_A8, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_A7, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_A6, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_A5, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_A4, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_A3, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_A2, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_A1, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),

	OMAP3_MUX(GPMC_D15, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D14, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D13, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D12, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D11, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D10, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D9, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D8, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D7, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D6, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D5, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D4, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D3, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D2, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D1, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(GPMC_D0, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),

	OMAP3_MUX(GPMC_NCS0, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_NCS1, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_NCS2, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_NCS3, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_NCS4, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_NCS5, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // User
	OMAP3_MUX(GPMC_NCS6, OMAP_MUX_MODE7 | OMAP_PIN_OUTPUT), // NC
	OMAP3_MUX(GPMC_NCS7, OMAP_MUX_MODE1 | OMAP_PIN_OUTPUT), // GPMC_IO_DIR

	OMAP3_MUX(GPMC_CLK, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_NADV_ALE, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_NOE, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_NWE, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_NBE0_CLE, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_NBE1, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_NWP, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(GPMC_WAIT0, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(GPMC_WAIT1, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(GPMC_WAIT2, OMAP_MUX_MODE4 | OMAP_PIN_INPUT), // Card detect on SAU-kit
	OMAP3_MUX(GPMC_WAIT3, OMAP_MUX_MODE7 | OMAP_PIN_OUTPUT), // NC

	OMAP3_MUX(UART1_CTS, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(UART1_RTS, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(UART1_TX, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(UART1_RX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),

	OMAP3_MUX(UART2_CTS, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLDOWN), // PULLDOWN for BT @ SDIO
	OMAP3_MUX(UART2_RTS, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(UART2_TX, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(UART2_RX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),

	OMAP3_MUX(UART3_CTS_RCTX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(UART3_RTS_SD, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(UART3_TX_IRTX, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(UART3_RX_IRRX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),

	OMAP3_MUX(SDMMC1_DAT4, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // GPIO_126, Accelerometer interrupt
	OMAP3_MUX(SDMMC1_DAT5, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // GPIO_127,
	OMAP3_MUX(SDMMC1_DAT6, OMAP_MUX_MODE4 | OMAP_PIN_OUTPUT), // GPIO_128, LVDS83 shdn
	OMAP3_MUX(SDMMC1_DAT7, OMAP_MUX_MODE4 | OMAP_PIN_OUTPUT), // GPIO_129, LVDS83 rsvd

	OMAP3_MUX(SDMMC2_DAT4, OMAP_MUX_MODE4 | OMAP_PIN_OUTPUT), // GPIO_136, WLAN PDn
	OMAP3_MUX(SDMMC2_DAT5, OMAP_MUX_MODE4 | OMAP_PIN_OUTPUT), // GPIO_137, WLAN nRST
	OMAP3_MUX(SDMMC2_DAT6, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // GPIO_138, WLAN WUP1
	OMAP3_MUX(SDMMC2_DAT7, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // GPIO_139, WLAN WUP2

	OMAP3_MUX(SAD2D_MCAD23, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLDOWN), // this is USB0_DRVVBUS!

	OMAP3_MUX(SAD2D_MCAD24, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP), // this is HECC TXD
	OMAP3_MUX(SAD2D_MCAD25, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP), // this is HECC RXD

	OMAP3_MUX(I2C1_SDA, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(I2C1_SCL, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),

	OMAP3_MUX(I2C2_SDA, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(I2C2_SCL, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),

	OMAP3_MUX(I2C3_SDA, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(I2C3_SCL, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),

	OMAP3_MUX(HDQ_SIO, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),

	OMAP3_MUX(SAD2D_MCAD0,  OMAP_MUX_MODE7), // this is CCDC_PCLK
	OMAP3_MUX(SAD2D_MCAD1,  OMAP_MUX_MODE7), // this is CCDC_FIELD
	OMAP3_MUX(SAD2D_MCAD2,  OMAP_MUX_MODE7), // this is CCDC_HD
	OMAP3_MUX(SAD2D_MCAD3,  OMAP_MUX_MODE7), // this is CCDC_VD
	OMAP3_MUX(SAD2D_MCAD4,  OMAP_MUX_MODE7), // this is CCDC_WEN
	OMAP3_MUX(SAD2D_MCAD5,  OMAP_MUX_MODE7), // this is CCDC_DATA0
	OMAP3_MUX(SAD2D_MCAD6,  OMAP_MUX_MODE7), // this is CCDC_DATA1
	OMAP3_MUX(SAD2D_MCAD7,  OMAP_MUX_MODE7), // this is CCDC_DATA2
	OMAP3_MUX(SAD2D_MCAD8,  OMAP_MUX_MODE7), // this is CCDC_DATA3
	OMAP3_MUX(SAD2D_MCAD9,  OMAP_MUX_MODE7), // this is CCDC_DATA4
	OMAP3_MUX(SAD2D_MCAD10,  OMAP_MUX_MODE7), // this is CCDC_DATA5
	OMAP3_MUX(SAD2D_MCAD11,  OMAP_MUX_MODE7), // this is CCDC_DATA6
	OMAP3_MUX(SAD2D_MCAD12,  OMAP_MUX_MODE7), // this is CCDC_DATA7

	OMAP3_MUX(SAD2D_MCAD13,  OMAP_MUX_MODE0 | OMAP_PIN_INPUT), // this is MDIO_DATA
	OMAP3_MUX(SAD2D_MCAD14,  OMAP_MUX_MODE0 | OMAP_PIN_INPUT), // this is MDIO_CLK
	OMAP3_MUX(SAD2D_MCAD15,  OMAP_MUX_MODE0 | OMAP_PIN_INPUT), // this is RMII_RXD0
	OMAP3_MUX(SAD2D_MCAD16,  OMAP_MUX_MODE0 | OMAP_PIN_INPUT), // this is RMII_RXD1
	OMAP3_MUX(SAD2D_MCAD17,  OMAP_MUX_MODE0 | OMAP_PIN_INPUT), // this is RMII_CRS_DV
	OMAP3_MUX(SAD2D_MCAD18,  OMAP_MUX_MODE0 | OMAP_PIN_INPUT), // this is RMII_RXER
	OMAP3_MUX(SAD2D_MCAD19,  OMAP_MUX_MODE0 | OMAP_PIN_INPUT), // this is RMII_TXD0
	OMAP3_MUX(SAD2D_MCAD20,  OMAP_MUX_MODE0 | OMAP_PIN_INPUT), // this is RMII_TXD1
	OMAP3_MUX(SAD2D_MCAD21,  OMAP_MUX_MODE0 | OMAP_PIN_INPUT), // this is RMII_TXEN
	OMAP3_MUX(SAD2D_MCAD22,  OMAP_MUX_MODE0 | OMAP_PIN_INPUT), // this is RMII_50MHZ_CLK

	OMAP3_MUX(SYS_CLKOUT1,  OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(SYS_CLKOUT2,  OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),

	OMAP3_MUX(SYS_NRESWARM, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),

	OMAP3_MUX(SYS_NIRQ,  OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // GPIO 0, PMIC Int
	OMAP3_MUX(SYS_CLKREQ,  OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),

	OMAP3_MUX(ETK_CLK, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2
	OMAP3_MUX(ETK_CTL, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2
	OMAP3_MUX(ETK_D0, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2
	OMAP3_MUX(ETK_D1, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2
	OMAP3_MUX(ETK_D2, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2
	OMAP3_MUX(ETK_D3, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2
	OMAP3_MUX(ETK_D4, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2
	OMAP3_MUX(ETK_D5, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2
	OMAP3_MUX(ETK_D6, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2
	OMAP3_MUX(ETK_D7, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2
	OMAP3_MUX(ETK_D8, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2
	OMAP3_MUX(ETK_D9, OMAP_MUX_MODE3 | OMAP_PIN_INPUT), // HSUSB 2

	OMAP3_MUX(ETK_D10, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // GPIO24 RTC Int
	OMAP3_MUX(ETK_D11, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // GPIO25 TSC Int
	OMAP3_MUX(ETK_D12, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // GPIO26 KBD Int
	OMAP3_MUX(ETK_D13, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // GPIO27 POWER_ON
	OMAP3_MUX(ETK_D14, OMAP_MUX_MODE4 | OMAP_PIN_OUTPUT), // GPIO28 USRLED
	OMAP3_MUX(ETK_D15, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLDOWN), // GPIO29 VBEN port 2

	OMAP3_MUX(SYS_BOOT0, OMAP_MUX_MODE4 | OMAP_PIN_INPUT), // GPIO 3 FAKE "Card detect" for WLAN SDIO
	OMAP3_MUX(SYS_BOOT1, OMAP_MUX_MODE4 | OMAP_PIN_OUTPUT), // GPIO 3, SERIALIZER CKSEL
	OMAP3_MUX(SYS_BOOT2, OMAP_MUX_MODE4 | OMAP_PIN_INPUT), // GPIO 4
	OMAP3_MUX(SYS_BOOT3, OMAP_MUX_MODE4 | OMAP_PIN_INPUT), // GPIO 5
	OMAP3_MUX(SYS_BOOT4, OMAP_MUX_MODE4 | OMAP_PIN_INPUT), // GPIO 6
	OMAP3_MUX(SYS_BOOT5, OMAP_MUX_MODE4 | OMAP_PIN_INPUT), // GPIO 7, BOOT5 (boot mode switch)
	OMAP3_MUX(SYS_BOOT6, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLDOWN), // GPIO 8 USB PHY Reset

	OMAP3_MUX(MCSPI1_CLK, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCSPI1_SIMO, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCSPI1_SOMI, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCSPI1_CS0, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCSPI1_CS1, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCSPI1_CS2, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // HMC5883L interrupt
	OMAP3_MUX(MCSPI1_CS3, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // PB_OUT

	OMAP3_MUX(MCSPI2_CLK, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCSPI2_SIMO, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCSPI2_SOMI, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCSPI2_CS0, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCSPI2_CS1, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // FAULT1 input on SAU kit

	OMAP3_MUX(MCBSP2_FSX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(MCBSP2_CLKX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(MCBSP2_DR, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(MCBSP2_DX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),

	OMAP3_MUX(MCBSP3_FSX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(MCBSP3_CLKX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(MCBSP3_DR, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),
	OMAP3_MUX(MCBSP3_DX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT),

	OMAP3_MUX(MCBSP4_FSX, OMAP_MUX_MODE4 | OMAP_PIN_INPUT), // GPIO 155 FAULT2 input, SAU Kit
	OMAP3_MUX(MCBSP4_CLKX, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLUP), // GPIO 152 LED2 on SAU kit
	OMAP3_MUX(MCBSP4_DR, OMAP_MUX_MODE4 | OMAP_PIN_INPUT), // GPIO 153 (WrProt on MMC slot on SAU kit)
	OMAP3_MUX(MCBSP4_DX, OMAP_MUX_MODE4 | OMAP_PIN_INPUT_PULLDOWN), // GPIO 154 (Disp ENA on SAU kit)

	OMAP3_MUX(MCBSP1_FSR, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCBSP1_CLKR, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCBSP1_FSX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCBSP1_CLKX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCBSP_CLKS, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCBSP1_DR, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),
	OMAP3_MUX(MCBSP1_DX, OMAP_MUX_MODE0 | OMAP_PIN_INPUT_PULLUP),

	OMAP3_MUX(DSS_DATA0, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA1, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA2, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA3, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA4, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA5, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA6, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA7, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA8, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA9, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA10, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA11, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA12, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA13, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA14, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA15, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA16, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA17, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA18, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA19, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA20, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA21, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA22, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_DATA23, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_PCLK, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_HSYNC, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_VSYNC, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),
	OMAP3_MUX(DSS_ACBIAS, OMAP_MUX_MODE0 | OMAP_PIN_OUTPUT),

	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#endif

/*
 * HECC information
 */

static void hecc_phy_control(int on)
{
}

static struct resource am3517_hecc_resources[] = {
	{
		.start	= AM35XX_IPSS_HECC_BASE,
		.end	= AM35XX_IPSS_HECC_BASE + 0x3FFF,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= INT_35XX_HECC0_IRQ,
		.end	= INT_35XX_HECC0_IRQ,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device am3517_hecc_device = {
	.name		= "ti_hecc",
	.id		= -1,
	.num_resources	= ARRAY_SIZE(am3517_hecc_resources),
	.resource	= am3517_hecc_resources,
};

static struct ti_hecc_platform_data sau3517_hecc_pdata = {
	.scc_hecc_offset	= AM35XX_HECC_SCC_HECC_OFFSET,
	.scc_ram_offset		= AM35XX_HECC_SCC_RAM_OFFSET,
	.hecc_ram_offset	= AM35XX_HECC_RAM_OFFSET,
	.mbx_offset		= AM35XX_HECC_MBOX_OFFSET,
	.int_line		= AM35XX_HECC_INT_LINE,
	.version		= AM35XX_HECC_VERSION,
	.transceiver_switch     = hecc_phy_control,
};

static void sau3517_hecc_init(struct ti_hecc_platform_data *pdata)
{
	am3517_hecc_device.dev.platform_data = pdata;
	platform_device_register(&am3517_hecc_device);
}

static struct omap2_hsmmc_info mmc[] = {
	{
		.mmc		= 1,
		.caps		= MMC_CAP_4_BIT_DATA,
		.gpio_cd	= 64,
		.gpio_wp	= 153,
	},
	{
		.mmc		= 2,
		.caps		= MMC_CAP_4_BIT_DATA,
		.gpio_cd	= GPIO_FAKE_MMC1_CD,
		.gpio_wp	= -EINVAL,
	},
	{}      /* Terminator */
};

static struct gpio_led gpio_leds[] = {
	{
		.name			= "hb",
		.gpio			= GPIO_USRLED,
		.active_low		= 1,
		.default_trigger	= "heartbeat",
	},
	{
		.name			= "pwr",
		.gpio			= GPIO_KIT_LED,
		.active_low		= 0,
		.default_state		= LEDS_GPIO_DEFSTATE_ON,
	},
};

static struct gpio_led_platform_data gpio_led_info = {
	.leds		= gpio_leds,
	.num_leds	= ARRAY_SIZE(gpio_leds),
};

static struct platform_device leds_gpio_dev = {
	.name	= "leds-gpio",
	.id	= -1,
	.dev	= {
		.platform_data	= &gpio_led_info,
	},
};

static struct platform_device bt_88w8688_dev = {
	.name	= "bt-88w8688-codec",
	.id	= -1,
};

static struct platform_device *sau3517_devices[] __initdata = {
	&sau3517_dss_device,
//	&dm644x_ccdc_dev,
	&vpfe_capture_dev,
	&ldo_da3_dev,
	&dcdc_da8_dev,
	&leds_gpio_dev,
	&bt_88w8688_dev,
};

static void sau3517_poweroff(void)
{

	msleep(250);
	gpio_direction_output(GPIO_PMIC_POWERON, 0);
	while (1);

}

static void sau3517_tmr_handler(unsigned long data);
static DEFINE_TIMER(sau3517_timer, sau3517_tmr_handler, 0, 0);

static uint wlan_enable = 1;
static uint wlan_enabled = 0;
static uint gps_enable = 0;
static uint gps_enabled = 0;

module_param_named(wlan_enable, wlan_enable, uint, S_IRUGO | S_IWUSR);
MODULE_PARM_DESC(wlan_enable, "Enable WLAN/BT. [Default=1]");
module_param_named(gps_enable, gps_enable, uint, S_IRUGO | S_IWUSR);
MODULE_PARM_DESC(gps_enable, "Enable GPS. [Default=0]");

int pb_timer;
int pb_off_timer;
struct work_struct shdn_work;

static void sau3517_tmr_handler(unsigned long data)
{

	if ((!wlan_enabled && wlan_enable) ||
	    (wlan_enabled && !wlan_enable)) {
		gpio_direction_output(GPIO_WL_PDN, wlan_enable ? 1 : 0);
		gpio_direction_output(GPIO_WL_NRST, wlan_enable ? 1 : 0);
		wlan_enabled = wlan_enable;
		printk(KERN_INFO "Module param \"wlan_enable\" change detected\n");
	}

	if ((!gps_enabled && gps_enable) ||
	    (gps_enabled && !gps_enable)) {
		gpio_direction_output(GPIO_GPSCTL, gps_enable ? 1 : 0);
		gps_enabled = gps_enable;
		printk(KERN_INFO "Module param \"gps_enable\" change detected\n");
	}

	if (gpio_is_requested(GPIO_FAKE_MMC1_CD) > 0)
		gpio_direction_output(GPIO_FAKE_MMC1_CD, wlan_enabled ? 0 : 1);

	mod_timer(&sau3517_timer, jiffies + msecs_to_jiffies(20));
}

static void sau3517_shutdown(struct work_struct *work)
{
	int	rc;

	printk("Shutdown initiated by power button\n");

	rc = orderly_poweroff(false);

	if (rc) 
		printk("/sbin/poweroff launch failed\n");

}

static void sau3517_initiate_shutdown(void)
{
	schedule_work(&shdn_work);
}

static void __init sau3517_init(void)
{
	u32 reg, i;

	omap3_mux_init(board_mux, OMAP_PACKAGE_CBB);
	omap_serial_init();

	/* WLAN/BT GPIO's */

	if ( gpio_request(GPIO_WL_PDN, "wl_pdn") < 0)
		printk(KERN_WARNING "failed to get wl_pdn\n");
	gpio_direction_output(GPIO_WL_PDN, wlan_enable ? 1 : 0);

	if ( gpio_request(GPIO_WL_WUP1, "wl_wup1") < 0)
		printk(KERN_WARNING "failed to get wl_wup1\n");
	gpio_direction_output(GPIO_WL_WUP1,1);

	if ( gpio_request(GPIO_WL_WUP2, "wl_wup2") < 0)
		printk(KERN_WARNING "failed to get wl_wup2\n");
	gpio_direction_output(GPIO_WL_WUP2,1);

	if ( gpio_request(GPIO_WL_NRST, "wl_nrst") < 0)
		printk(KERN_WARNING "failed to get wl_nrst\n");
	gpio_direction_output(GPIO_WL_NRST,0);

#ifndef CONFIG_INPUT_BMA250
	if ( gpio_request(GPIO_BT_DTR, "bt_dtr") < 0)
		printk(KERN_WARNING "failed to get bt_dtr\n");
	gpio_direction_output(GPIO_BT_DTR,0);

	if ( gpio_request(GPIO_BT_DSR, "bt_dsr") < 0)
		printk(KERN_WARNING "failed to get bt_dsr\n");
	gpio_direction_input(GPIO_BT_DSR);
#else
	if ( gpio_request(GPIO_ACC_INT, "acc_int") < 0)
		printk(KERN_WARNING "failed to get acc_int\n");
#endif

#ifdef CONFIG_SENSORS_HMC5843
	if ( gpio_request(GPIO_MAG_IRQ, "mag_int") < 0)
		printk(KERN_WARNING "failed to get mag_int\n");
#endif

        /* Enable SYS_CLKOUT1 */
	omap2_clk_enable(clk_get(NULL,"sys_clkout1"));

	/* Configure GPIO for VBUS switch on EHCI */
	if ( gpio_request(GPIO_VBEN_USB1, "vben_usb1") < 0)
		printk(KERN_WARNING "failed to get vben_usb1\n");
	gpio_direction_output(GPIO_VBEN_USB1,0);
	gpio_set_value(GPIO_VBEN_USB1, 1);

	sau3517_i2c_init();
	platform_add_devices(sau3517_devices,
				ARRAY_SIZE(sau3517_devices));

	/* EHCI */
	usb_ehci_init(&ehci_pdata);
	/* MUSB */
	sau3517_musb_init();

	/* RTC - DS1374 */
	if (gpio_request(GPIO_DS1374_IRQ, "rtcds1374-irq") < 0)
		printk(KERN_WARNING "failed to request GPIO#%d\n",
				GPIO_DS1374_IRQ);
	if (gpio_direction_input(GPIO_DS1374_IRQ))
		printk(KERN_WARNING "GPIO#%d cannot be configured as "
				"input\n", GPIO_DS1374_IRQ);
	sau3517_i2c1_boardinfo[0].irq = gpio_to_irq(GPIO_DS1374_IRQ);

	/* PMIC - TPS650732 */
	if (gpio_request(GPIO_PMIC_IRQ, "pmic-irq") < 0)
		printk(KERN_WARNING "failed to request GPIO#%d\n",
				GPIO_PMIC_IRQ);
	if (gpio_direction_input(GPIO_PMIC_IRQ))
		printk(KERN_WARNING "GPIO#%d cannot be configured as "
				"input\n", GPIO_PMIC_IRQ);
	sau3517_i2c1_boardinfo[2].irq = gpio_to_irq(GPIO_PMIC_IRQ);

	/* KEYPAD - TCA8418 */
	if (gpio_request(GPIO_TCA8418_IRQ, "keypad-irq") < 0)
		printk(KERN_WARNING "failed to request GPIO#%d\n",
				GPIO_TCA8418_IRQ);
	if (gpio_direction_input(GPIO_TCA8418_IRQ))
		printk(KERN_WARNING "GPIO#%d cannot be configured as "
				"input\n", GPIO_TCA8418_IRQ);
	sau3517_i2c1_boardinfo[4].irq = gpio_to_irq(GPIO_TCA8418_IRQ);

	i=5;

#ifdef CONFIG_INPUT_BMA250
	/* BMA250 accelerometer */
	gpio_direction_input(GPIO_ACC_INT);
	sau3517_i2c1_boardinfo[i++].irq = gpio_to_irq(GPIO_ACC_INT);
#endif
#ifdef CONFIG_INPUT_BMP180
	i++;
#endif
#ifdef CONFIG_SENSORS_HMC5843
	gpio_direction_input(GPIO_MAG_IRQ);
	sau3517_i2c1_boardinfo[i++].irq = gpio_to_irq(GPIO_MAG_IRQ);
#endif

	if (gpio_request(GPIO_PMIC_POWERON, "pmic_poweron"))
		printk(KERN_ERR "Unable to get POWER_ON gpio\n");
	INIT_WORK(&shdn_work, &sau3517_shutdown);

	i2c_register_board_info(1, sau3517_i2c1_boardinfo,
				ARRAY_SIZE(sau3517_i2c1_boardinfo));

/*
	clk_add_alias("master", "dm644x_ccdc", "master",
			&vpfe_capture_dev.dev);
	clk_add_alias("slave", "dm644x_ccdc", "slave",
			&vpfe_capture_dev.dev);
*/

	/* DSS */
	sau3517_display_init();

	/* NAND */
	board_nand_init(sau3517_nand_partitions,
					ARRAY_SIZE(sau3517_nand_partitions), 0, 0);

	/*Ethernet*/
	sau3517_ethernet_init(&sau3517_emac_pdata);
	sau3517_hecc_init(&sau3517_hecc_pdata);

	/* MMC init function */
	reg = omap_ctrl_readl(OMAP343X_CONTROL_DEVCONF1);
	reg |= OMAP2_MMCSDIO2ADPCLKISEL;
	omap_ctrl_writel(reg,OMAP343X_CONTROL_DEVCONF1);
	omap2_hsmmc_init(mmc);

	/* Out WLAN/BT from reset if needed */
	gpio_direction_output(GPIO_WL_NRST,wlan_enable ? 1 : 0);

	if (gpio_request(GPIO_GPSCTL, "gpsctl"))
		printk(KERN_ERR "Unable to get GPSCTL gpio\n");
	gpio_direction_output(GPIO_GPSCTL, 0);

	/* Initialize and start timer for on-the-fly changes detect
	   power button, module parameters, e.t.c. */
	pm_power_off = sau3517_poweroff;
	pb_timer = 100/20; /* 100 ms minimum to initiate shutdown */
	pb_off_timer = 5000/20; /* 5s to forced power off */
	mod_timer(&sau3517_timer, jiffies + msecs_to_jiffies(20));
	wlan_enabled = wlan_enable;

}

MACHINE_START(SAU3517, "AM3517/05 SAUModule")
	.boot_params	= 0x80000100,
	.map_io		= omap3_map_io,
	.reserve	= omap_reserve,
	.init_irq	= sau3517_init_irq,
	.init_machine	= sau3517_init,
	.timer		= &omap_timer,
MACHINE_END
